/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.freemarker;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.generic.step.BaseDeploymentStep;
import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.dom.NodeModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ContextXmlHelper {
    private BaseDeploymentStep step;

    public ContextXmlHelper(BaseDeploymentStep step) {
        this.step = step;
    }

    public NodeModel readOrCreateContext(String path) {
        if (!this.step.hostFileExists(path)) {
            this.step.createOrReplaceHostFile("<Context></Context>", path);
        }
        return this.step.readHostXmlFileAsModel(path);
    }

    public String attributeMapToString(Map<String, String> map) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.append(entry.getKey()).append("=\"").append(entry.getValue()).append("\" ");
        }
        return builder.toString();
    }

    public Map<String, String> resolveElementAttributes(NodeModel nodeModel, BeanModel ci, Map<String, String> propertyToAttributeMapping, boolean isDestroyOperation) throws TemplateModelException {
        HashMap attributes = Maps.newHashMap();
        if (isDestroyOperation) {
            List<String> attrNames = this.resolveAttributeNamesFromPropertyToAttributeMapping(propertyToAttributeMapping);
            attributes.putAll(this.removeAttributes(nodeModel, attrNames));
        } else {
            Map<String, String> elementAttrsFromCi = this.populateElementAttributesFromCi(ci, propertyToAttributeMapping);
            attributes.putAll(this.mergeWithElementAttributes(nodeModel, elementAttrsFromCi));
        }
        return attributes;
    }

    public Map<String, String> populateElementAttributesFromCi(BeanModel ci, Map<String, String> propertyToAttributeMapping) throws TemplateModelException {
        HashMap attributes = Maps.newHashMap();
        BeansWrapper beansWrapper = BeansWrapper.getDefaultInstance();
        for (Map.Entry<String, String> entry : propertyToAttributeMapping.entrySet()) {
            String propertyName = entry.getKey();
            String attributeName = Strings.emptyToNull((String)entry.getValue()) == null ? propertyName : entry.getValue();
            TemplateModel tm = ci.get(propertyName);
            Object value = beansWrapper.unwrap(tm);
            if (value instanceof Map) {
                value = this.convertMapToTomcatMapStringFormat((Map)value);
            }
            if (value == null) continue;
            attributes.put(attributeName, value.toString());
        }
        return attributes;
    }

    protected List<String> resolveAttributeNamesFromPropertyToAttributeMapping(Map<String, String> propertyToAttributeMapping) {
        ArrayList attributes = Lists.newArrayList();
        for (Map.Entry<String, String> entry : propertyToAttributeMapping.entrySet()) {
            String propertyName = entry.getKey();
            String attributeName = Strings.emptyToNull((String)entry.getValue()) == null ? propertyName : entry.getValue();
            attributes.add(attributeName);
        }
        return attributes;
    }

    protected String convertMapToTomcatMapStringFormat(Map<String, String> map) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.append(entry.getKey()).append('=').append(entry.getValue()).append(';');
        }
        return builder.toString();
    }

    protected Map<String, String> mergeWithElementAttributes(NodeModel nodeModel, Map<String, String> overrideAttributes) throws TemplateModelException {
        Node node = nodeModel.getNode();
        HashMap mergedAttributes = Maps.newHashMap();
        NamedNodeMap attributes = node.getAttributes();
        int size = attributes == null ? 0 : attributes.getLength();
        for (int i = 0; i < size; ++i) {
            Node attr = attributes.item(i);
            mergedAttributes.put(attr.getNodeName(), attr.getNodeValue());
        }
        mergedAttributes.putAll(overrideAttributes);
        return mergedAttributes;
    }

    protected Map<String, String> removeAttributes(NodeModel nodeModel, Collection<String> attributesToRemove) throws TemplateModelException {
        Node node = nodeModel.getNode();
        HashMap mergedAttributes = Maps.newHashMap();
        NamedNodeMap attributes = node.getAttributes();
        int size = attributes == null ? 0 : attributes.getLength();
        for (int i = 0; i < size; ++i) {
            Node attr = attributes.item(i);
            if (attributesToRemove.contains(attr.getNodeName())) continue;
            mergedAttributes.put(attr.getNodeName(), attr.getNodeValue());
        }
        return mergedAttributes;
    }
}

