<#--

    Copyright (c) 2018. All rights reserved.

    This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.

-->
#!/bin/bash
<#assign envVars=container.envVars />
<#list envVars?keys as envVar>
${envVar}="${envVars[envVar]}"
export ${envVar}
</#list>
cd "${container.home}"

check_status() {
    if [ $? -eq 0 ] && [ ! -z "$pid" ] ; then
        echo "server is started successfully"
    else
        echo "Server is not started, Check the logs, start and status command"
        exit 1
    fi
}

execute_status_command() {
    <#if container.statusCommand??>
        ${container.statusCommand}
    <#elseif container.tomcatRunningPort??>
        pid=$(lsof -t -i :${container.tomcatRunningPort} -s)
    <#else>
        echo "Tomcat running status is not checked. To check, set status command or port"
        echo "Executed start command"
        ${container.startCommand}
        exit 0
    </#if>
}

check_initial_status() {
    execute_status_command
    if [ $? -eq 0 ] && [ ! -z "$pid" ] ; then
        status=RUNNING
    elif [ $? -eq 0 ] ; then
        echo "Check the status command"
    else
        status=STOPPED
    fi
}

check_initial_status
if [ "$status" != "RUNNING" ] ; then
    ${container.startCommand}
    sleep ${container.serverStartupTime}s
    execute_status_command
    check_status
else
    echo "Server is already running, nothing to do"
fi

