<#--

    Copyright (c) 2018. All rights reserved.

    This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.

-->
@echo off
setlocal enabledelayedexpansion
<#assign envVars=container.envVars />
<#list envVars?keys as envVar>
set ${envVar}="${envVars[envVar]}"
</#list>
cd /D "${container.home}"
goto :checkStatus

:checkStatus
<#if container.statusCommand??>
${container.statusCommand}
if not %ERRORLEVEL% == 0 goto :errorStatusResponse
if !pid! gtr 0 (
goto :stopTomcat
)  else (
echo Server is already stopped, nothing to do
)
<#else>
for /f "tokens=5" %%a in ('netstat -aon ^| findstr 0.0.0.0:${container.tomcatRunningPort}') do set pid=%%~nxa
if !pid! gtr 0 (
goto :stopTomcat
)  else (
echo Server is already stopped, nothing to do
)
</#if>
goto :EOF

:stopTomcat
${container.stopCommand}
if not %ERRORLEVEL% == 0 goto :errorStopResponse
PING localhost -n ${container.serverShutdownTime} >NUL
tasklist /FI "SessionName eq services" | find /I "tomcat" | find /I ".exe"> NUL
set err=%errorlevel%
goto :checkStatusAndShowResult

:checkStatusAndShowResult
if %err% == 1 (
echo Tomcat server is stopped
) else (
echo server is not stopped please check the stop command
)
goto :EOF

:errorStatusResponse
echo please check the status command
goto :EOF

:errorStopResponse
echo please check the stop command
goto :EOF

:EOF
