/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.processor;

import com.google.common.collect.Iterables;
import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.tomcat.deployed.ContextElement;
import com.xebialabs.deployit.plugin.tomcat.processor.Utils;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonContextNameInjector {
    public static final Type COMMON_CONTEXT_TYPE = Type.valueOf((String)"tomcat.CommonContext");
    private static final Logger logger = LoggerFactory.getLogger(CommonContextNameInjector.class);

    @PrePlanProcessor
    public static List<Step> injectContextNameInToContextElements(DeltaSpecification spec) {
        Iterable<AbstractDeployed<?>> deployeds = CommonContextNameInjector.findDeployedsTargetedToCommonContexts(spec.getDeltas());
        logger.debug("Found {} deployeds targeted to common context", (Object)Iterables.size(deployeds));
        CommonContextNameInjector.injectCommonContextNameIntoContextElements(deployeds);
        return Collections.emptyList();
    }

    protected static void injectCommonContextNameIntoContextElements(Iterable<AbstractDeployed<?>> abstractDeployeds) {
        Iterable<ContextElement<?>> elements = CommonContextNameInjector.extractContextElements(abstractDeployeds);
        logger.debug("Found {} context elements targeted to common context", (Object)Iterables.size(elements));
        for (ContextElement<?> resource : elements) {
            resource.setContext("context");
        }
    }

    protected static Iterable<ContextElement<?>> extractContextElements(Iterable<AbstractDeployed<?>> abstractDeployeds) {
        return Utils.extractDeployedContextElements(abstractDeployeds);
    }

    protected static Iterable<AbstractDeployed<?>> findDeployedsTargetedToCommonContexts(List<Delta> deltas) {
        return Utils.findDeployedsTargetedToContainer(deltas, COMMON_CONTEXT_TYPE);
    }
}

