package com.xebialabs.deployit.spel

package object utils {
  def toOption[T](obj: T): Option[T] = Option(obj)

  def ifPresentDo[R](obj: AnyRef, default: R)(func: () => R): R =
    toOption(obj) match {
      case Some(_) => func()
      case None => default
    }

  def ifPresentDoOrNull[R]: AnyRef => (() => R) => R = ifPresentDo[R](_, null.asInstanceOf[R])
}
