package com.xebialabs.deployit.spel.utils.input

import com.xebialabs.deployit.plugin.stitch.service.engine.context.{DeploymentContext, InputContext}
import com.xebialabs.deployit.plugin.stitch.service.engine.processor.handler.expression.annotation.ExpressionUtility
import com.xebialabs.deployit.plugin.stitch.service.engine.processor.handler.expression.resolver.AbstractContextResolver

@ExpressionUtility("k8s")
class K8sResolver(deploymentContext: DeploymentContext, inputContext: InputContext)
    extends AbstractContextResolver(deploymentContext, inputContext) {
  private val KindPath = "$.kind"
  private val Deployment = "Deployment"
  private val Service = "Service"
  private val Ingress = "Ingress"
  private val PersistentVolume = "PersistentVolume"
  private val Secret = "Secret"
  private val ConfigMap = "ConfigMap"

  private val inputStringValuesResolver = new InputStringValuesResolver(deploymentContext, inputContext)
  def isKind(kind: String): Boolean = inputStringValuesResolver.valueEquals(KindPath, kind)
  def isDeployment: Boolean = isKind(Deployment)
  def isService: Boolean = isKind(Service)
  def isIngress: Boolean = isKind(Ingress)
  def isPersistentVolume: Boolean = isKind(PersistentVolume)
  def isSecret: Boolean = isKind(Secret)
  def isConfigMap: Boolean = isKind(ConfigMap)
}
