package com.xebialabs.deployit.spel.utils.input

import com.xebialabs.deployit.plugin.stitch.service.engine.context.{DeploymentContext, InputContext}
import com.xebialabs.deployit.plugin.stitch.service.engine.processor.handler.expression.annotation.ExpressionUtility
import com.xebialabs.deployit.plugin.stitch.service.engine.processor.handler.expression.resolver.AbstractContextResolver

@ExpressionUtility("pathString")
class InputStringValuesResolver(deploymentContext: DeploymentContext, inputContext: InputContext)
    extends AbstractContextResolver(deploymentContext, inputContext) {
  def value(path: String): String = inputContext.getStringValue(path)
  def valueEquals(path: String, right: String): Boolean =
    Option(value(path)).getOrElse(false).equals(right)
  def valueContains(path: String, right: String): Boolean =
    Option(value(path)).exists(pathValue => Option(right).exists(pathValue.contains))
  def valueMatches(path: String, regexp: String): Boolean =
    Option(value(path)).exists(pathValue => Option(regexp).exists(pathValue.matches))
}
