package com.xebialabs.deployit.spel.utils.deployedapplication

import com.xebialabs.deployit.plugin.api.udm.DeployedApplication
import com.xebialabs.deployit.plugin.stitch.service.engine.context.{DeploymentContext, InputContext}
import com.xebialabs.deployit.spel.utils.{ifPresentDoOrNull, BaseCiResolver}

abstract class BaseDeployedApplicationResolver(deploymentContext: DeploymentContext, inputContext: InputContext)
    extends BaseCiResolver[DeployedApplication](deploymentContext, inputContext) {
  def version: String =
    ifPresent { () =>
      get().getVersion.getVersion
    }
  override def id(): String =
    ifPresent { () =>
      super.id()
    }
  override def name: String =
    ifPresent { () =>
      super.name
    }
  override def nameEquals(string: String): Boolean =
    ifPresent { () =>
      super.nameEquals(string)
    }
  override def nameMatches(pattern: String): Boolean =
    ifPresent { () =>
      super.nameMatches(pattern)
    }
  override def nameContains(subString: String): Boolean =
    ifPresent { () =>
      super.nameContains(subString)
    }

  private def ifPresent[R] = ifPresentDoOrNull[R](get())
}
