package com.xebialabs.deployit.spel.utils.deployed

import com.xebialabs.deployit.plugin.api.udm.{Container, Deployable, Deployed}
import com.xebialabs.deployit.plugin.stitch.service.engine.context.{DeploymentContext, InputContext}
import com.xebialabs.deployit.spel.utils.{ifPresentDoOrNull, toOption, BaseCiResolver}

abstract class BaseDeployedResolver(deploymentContext: DeploymentContext, inputContext: InputContext)
    extends BaseCiResolver[Deployed[_, _]](deploymentContext, inputContext) {
  def get(): Deployed[_, _]
  final def container: String =
    (for {
      deployed <- toOption(get())
      container <- toOption(deployed.getContainer.asInstanceOf[Container])
      id <- toOption(container.getId)
    } yield id).orNull

  final def deployable: String =
    ifPresent { () =>
      get().getDeployable.asInstanceOf[Deployable].getId
    }
  final override def id(): String =
    ifPresent { () =>
      super.id()
    }
  final override def name: String =
    ifPresent { () =>
      super.name
    }
  final override def nameEquals(string: String): Boolean =
    ifPresent { () =>
      super.nameEquals(string)
    }
  final override def nameMatches(pattern: String): Boolean =
    ifPresent { () =>
      super.nameMatches(pattern)
    }
  final override def nameContains(subString: String): Boolean =
    ifPresent { () =>
      super.nameContains(subString)
    }

  private def ifPresent[R] = ifPresentDoOrNull[R](get())
}
