package com.xebialabs.deployit.spel.utils

import java.util

import com.xebialabs.deployit.plugin.api.udm.transformer.PatchDictionary
import com.xebialabs.deployit.plugin.api.udm.{ConfigurationItem, Container, Environment, IDictionary}
import com.xebialabs.deployit.plugin.stitch.service.engine.context.{DeploymentContext, InputContext}
import com.xebialabs.deployit.plugin.stitch.service.engine.processor.handler.expression.annotation.ExpressionUtility
import com.xebialabs.deployit.spel.utils.deployedapplication.DeployedApplicationResolver

@SuppressWarnings(Array("asInstanceOf"))
@ExpressionUtility("environment")
class EnvironmentResolver(deploymentContext: DeploymentContext, inputContext: InputContext)
    extends BaseCiResolver[Environment](deploymentContext, inputContext) {
  private val deployedApplicationResolver = new DeployedApplicationResolver(deploymentContext, inputContext)
  override def get(): Environment = deployedApplicationResolver.get().getEnvironment

  def dictionaries: util.List[IDictionary] = get().getDictionaries
  def members: util.Set[Container] = get().getMembers
  def patchDictionaries: util.List[PatchDictionary] = get().getPatchDictionaries

  def getDictionary(id: String): IDictionary =
    findCiById(id, dictionaries.asInstanceOf[util.List[ConfigurationItem]]).asInstanceOf[IDictionary]
  def getDictionaryValue(id: String, key: String): String = Option(getDictionary(id)).map(dict => dict.getValue(key)).orNull

  def getMember(id: String): Container = findCiById(id, members.asInstanceOf[util.Set[ConfigurationItem]]).asInstanceOf[Container]

  private def findCiById[T](id: String, cis: util.Collection[ConfigurationItem]) =
    cis.stream().filter(_.getId.equals(id)).findFirst().orElseGet(() => null)
}
