package com.xebialabs.deployit.spel.utils

import com.xebialabs.deployit.plugin.api.udm.Container
import com.xebialabs.deployit.plugin.stitch.service.engine.context.{DeploymentContext, InputContext}
import com.xebialabs.deployit.plugin.stitch.service.engine.processor.handler.expression.annotation.ExpressionUtility
import com.xebialabs.deployit.plugin.stitch.service.engine.processor.handler.expression.resolver.AbstractContextResolver
import com.xebialabs.deployit.service.replacement.{ConsolidatedDictionary, Dictionaries}
import com.xebialabs.deployit.spel.utils.deployedapplication.DeployedApplicationResolver
import com.xebialabs.deployit.spel.utils.deployed.DeployedResolver

@ExpressionUtility("dictionary")
class DictionaryResolver(deploymentContext: DeploymentContext, inputContext: InputContext)
    extends AbstractContextResolver(deploymentContext, inputContext) {
  private val environmentResolver = new EnvironmentResolver(deploymentContext, inputContext)
  private val deployedApplicationResolver = new DeployedApplicationResolver(deploymentContext, inputContext)
  private val deployedResolver = new DeployedResolver(deploymentContext, inputContext)
  def get: ConsolidatedDictionary =
    Dictionaries
      .of(environmentResolver.get())
      .filterBy(deployedApplicationResolver.get().getVersion)
      .filterBy(deployedResolver.get().getContainer.asInstanceOf[Container])
      .consolidate()
  def containsKey(key: String): Boolean = get.containsKey(key)
  def getValue(key: String): String = get.get(key)
}
