/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import com.nimbusds.jose.jwk.JWK;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.xebialabs.deployit.ServerConfiguration;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.web.util.UriComponentsBuilder;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t\u0005d\u0001\u0002.\\\u0001!D\u0001b\u001c\u0001\u0003\u0002\u0003\u0006I\u0001\u001d\u0005\to\u0002\u0011\t\u0011)A\u0005q\")a\u0010\u0001C\u0001\u007f\"I\u0011\u0011\u0002\u0001C\u0002\u0013\u0005\u00111\u0002\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u000e!I\u0011Q\u0005\u0001C\u0002\u0013\u0005\u00111\u0002\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u000e!I\u0011\u0011\u0006\u0001C\u0002\u0013\u0005\u00111\u0002\u0005\t\u0003W\u0001\u0001\u0015!\u0003\u0002\u000e!I\u0011Q\u0006\u0001C\u0002\u0013\u0005\u00111\u0002\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002\u000e!I\u0011\u0011\u0007\u0001C\u0002\u0013\u0005\u00111\u0002\u0005\t\u0003g\u0001\u0001\u0015!\u0003\u0002\u000e!I\u0011Q\u0007\u0001C\u0002\u0013\u0005\u00111\u0002\u0005\t\u0003o\u0001\u0001\u0015!\u0003\u0002\u000e!I\u0011\u0011\b\u0001A\u0002\u0013\u0005\u00111\u0002\u0005\n\u0003w\u0001\u0001\u0019!C\u0001\u0003{A\u0001\"!\u0013\u0001A\u0003&\u0011Q\u0002\u0005\n\u0003\u0017\u0002\u0001\u0019!C\u0001\u0003\u0017A\u0011\"!\u0014\u0001\u0001\u0004%\t!a\u0014\t\u0011\u0005M\u0003\u0001)Q\u0005\u0003\u001bA\u0011\"!\u0016\u0001\u0001\u0004%\t!a\u0003\t\u0013\u0005]\u0003\u00011A\u0005\u0002\u0005e\u0003\u0002CA/\u0001\u0001\u0006K!!\u0004\t\u0013\u0005}\u0003A1A\u0005\u0002\u0005-\u0001\u0002CA1\u0001\u0001\u0006I!!\u0004\t\u0013\u0005\r\u0004A1A\u0005\u0002\u0005-\u0001\u0002CA3\u0001\u0001\u0006I!!\u0004\t\u0013\u0005\u001d\u0004A1A\u0005\u0002\u0005-\u0001\u0002CA5\u0001\u0001\u0006I!!\u0004\t\u0013\u0005-\u0004A1A\u0005\u0002\u0005-\u0001\u0002CA7\u0001\u0001\u0006I!!\u0004\t\u0013\u0005=\u0004A1A\u0005\u0002\u0005-\u0001\u0002CA9\u0001\u0001\u0006I!!\u0004\t\u0013\u0005M\u0004A1A\u0005\u0002\u0005-\u0001\u0002CA;\u0001\u0001\u0006I!!\u0004\t\u0013\u0005]\u0004A1A\u0005\u0002\u0005-\u0001\u0002CA=\u0001\u0001\u0006I!!\u0004\t\u0013\u0005m\u0004A1A\u0005\u0002\u0005-\u0001\u0002CA?\u0001\u0001\u0006I!!\u0004\t\u0013\u0005}\u0004A1A\u0005\u0002\u0005-\u0001\u0002CAA\u0001\u0001\u0006I!!\u0004\t\u0013\u0005\r\u0005A1A\u0005\u0002\u0005-\u0001\u0002CAC\u0001\u0001\u0006I!!\u0004\t\u0013\u0005\u001d\u0005A1A\u0005\u0002\u0005-\u0001\u0002CAE\u0001\u0001\u0006I!!\u0004\t\u0013\u0005-\u0005A1A\u0005\u0002\u0005-\u0001\u0002CAG\u0001\u0001\u0006I!!\u0004\t\u0013\u0005=\u0005A1A\u0005\u0002\u0005-\u0001\u0002CAI\u0001\u0001\u0006I!!\u0004\t\u0013\u0005M\u0005A1A\u0005\u0002\u0005-\u0001\u0002CAK\u0001\u0001\u0006I!!\u0004\t\u0013\u0005]\u0005A1A\u0005\u0002\u0005-\u0001\u0002CAM\u0001\u0001\u0006I!!\u0004\t\u0013\u0005m\u0005A1A\u0005\u0002\u0005-\u0001\u0002CAO\u0001\u0001\u0006I!!\u0004\t\u0013\u0005}\u0005A1A\u0005\u0002\u0005\u0005\u0006\u0002CA`\u0001\u0001\u0006I!a)\t\u0013\u0005\u0005\u0007A1A\u0005\u0002\u0005-\u0001\u0002CAb\u0001\u0001\u0006I!!\u0004\t\u0013\u0005\u0015\u0007A1A\u0005\u0002\u0005-\u0001\u0002CAd\u0001\u0001\u0006I!!\u0004\t\u0013\u0005%\u0007A1A\u0005\u0002\u0005-\u0001\u0002CAf\u0001\u0001\u0006I!!\u0004\t\u0013\u00055\u0007A1A\u0005\u0002\u0005-\u0001\u0002CAh\u0001\u0001\u0006I!!\u0004\t\u0013\u0005E\u0007A1A\u0005\u0002\u0005-\u0001\u0002CAj\u0001\u0001\u0006I!!\u0004\t\u0013\u0005U\u0007A1A\u0005\u0002\u0005-\u0001\u0002CAl\u0001\u0001\u0006I!!\u0004\t\u0013\u0005e\u0007A1A\u0005\u0002\u0005-\u0001\u0002CAn\u0001\u0001\u0006I!!\u0004\t\u0013\u0005u\u0007A1A\u0005\u0002\u0005-\u0001\u0002CAp\u0001\u0001\u0006I!!\u0004\t\u0013\u0005\u0005\b\u00011A\u0005\u0002\u0005\r\b\"CAv\u0001\u0001\u0007I\u0011AAw\u0011!\t\t\u0010\u0001Q!\n\u0005\u0015\bbCAz\u0001\u0001\u0007\t\u0019!C\u0001\u0003kD1B!\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003\f!Y!q\u0002\u0001A\u0002\u0003\u0005\u000b\u0015BA|\u0011%\u0011\t\u0002\u0001a\u0001\n\u0003\u0011\u0019\u0002C\u0005\u0003\u001c\u0001\u0001\r\u0011\"\u0001\u0003\u001e!A!\u0011\u0005\u0001!B\u0013\u0011)\u0002C\u0004\u0003$\u0001!IA!\n\t\u000f\tE\u0002\u0001\"\u0003\u00034!9!1\b\u0001\u0005\n\tu\u0002b\u0002B\"\u0001\u0011%!Q\t\u0005\b\u0005\u001b\u0002A\u0011\u0002B(\u0011\u001d\u00119\u0006\u0001C\u0005\u00053\u0012!bT5eG\u000e{gNZ5h\u0015\taV,\u0001\u0003d_:4'B\u00010`\u0003\u0011y\u0017\u000eZ2\u000b\u0005\u0001\f\u0017AD1vi\",g\u000e^5dCRLwN\u001c\u0006\u0003E\u000e\f\u0001\u0002\u001f7eKBdw.\u001f\u0006\u0003I\u0016\f\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0019\f1aY8n\u0007\u0001\u0019\"\u0001A5\u0011\u0005)lW\"A6\u000b\u00031\fQa]2bY\u0006L!A\\6\u0003\r\u0005s\u0017PU3g\u0003\u0019\u0019wN\u001c4jOB\u0011\u0011/^\u0007\u0002e*\u0011qn\u001d\u0006\u0003i\u0016\f\u0001\u0002^=qKN\fg-Z\u0005\u0003mJ\u0014aaQ8oM&<\u0017aE:feZ,'oQ8oM&<WO]1uS>t\u0007CA=}\u001b\u0005Q(BA>d\u0003!!W\r\u001d7ps&$\u0018BA?{\u0005M\u0019VM\u001d<fe\u000e{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q1\u0011\u0011AA\u0003\u0003\u000f\u00012!a\u0001\u0001\u001b\u0005Y\u0006\"B8\u0004\u0001\u0004\u0001\b\"B<\u0004\u0001\u0004A\u0018A\u0004:fO&\u001cHO]1uS>t\u0017\nZ\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u001e9!\u0011\u0011CA\r!\r\t\u0019b[\u0007\u0003\u0003+Q1!a\u0006h\u0003\u0019a$o\\8u}%\u0019\u00111D6\u0002\rA\u0013X\rZ3g\u0013\u0011\ty\"!\t\u0003\rM#(/\u001b8h\u0015\r\tYb[\u0001\u0010e\u0016<\u0017n\u001d;sCRLwN\\%eA\u0005A1\r\\5f]RLE-A\u0005dY&,g\u000e^%eA\u0005a1\r\\5f]R\u001cVm\u0019:fi\u0006i1\r\\5f]R\u001cVm\u0019:fi\u0002\n\u0001c\u00197jK:$\u0018)\u001e;i\u001b\u0016$\bn\u001c3\u0002#\rd\u0017.\u001a8u\u0003V$\b.T3uQ>$\u0007%\u0001\tdY&,g\u000e^!vi\"TukU!mO\u0006\t2\r\\5f]R\fU\u000f\u001e5K/N\u000bEn\u001a\u0011\u0002\u0015Q|7.\u001a8LKfLE-A\u0006u_.,gnS3z\u0013\u0012\u0004\u0013\u0001D6fsN#xN]3QCRD\u0017\u0001E6fsN#xN]3QCRDw\fJ3r)\u0011\ty$!\u0012\u0011\u0007)\f\t%C\u0002\u0002D-\u0014A!\u00168ji\"I\u0011qI\t\u0002\u0002\u0003\u0007\u0011QB\u0001\u0004q\u0012\n\u0014!D6fsN#xN]3QCRD\u0007%\u0001\tlKf\u001cFo\u001c:f!\u0006\u001c8o^8sI\u0006!2.Z=Ti>\u0014X\rU1tg^|'\u000fZ0%KF$B!a\u0010\u0002R!I\u0011q\t\u000b\u0002\u0002\u0003\u0007\u0011QB\u0001\u0012W\u0016L8\u000b^8sKB\u000b7o]<pe\u0012\u0004\u0013\u0001D6fsN#xN]3UsB,\u0017\u0001E6fsN#xN]3UsB,w\fJ3r)\u0011\ty$a\u0017\t\u0013\u0005\u001ds#!AA\u0002\u00055\u0011!D6fsN#xN]3UsB,\u0007%\u0001\u0005lKf\fE.[1t\u0003%YW-_!mS\u0006\u001c\b%A\u0006lKf\u0004\u0016m]:x_J$\u0017\u0001D6fsB\u000b7o]<pe\u0012\u0004\u0013a\u00053fM\u0006,H\u000e^&fsN#xN]3QCRD\u0017\u0001\u00063fM\u0006,H\u000e^&fsN#xN]3QCRD\u0007%A\feK\u001a\fW\u000f\u001c;LKf\u001cFo\u001c:f!\u0006\u001c8o^8sI\u0006AB-\u001a4bk2$8*Z=Ti>\u0014X\rU1tg^|'\u000f\u001a\u0011\u0002\r%\u001c8/^3s\u0003\u001dI7o];fe\u0002\n\u0001B[<lg~+(/[\u0001\nU^\\7oX;sS\u0002\na\"Y2dKN\u001cHk\\6f]V\u0013\u0018.A\bbG\u000e,7o\u001d+pW\u0016tWK]5!\u0003Q)8/\u001a:BkRDwN]5{CRLwN\\+sS\u0006)Ro]3s\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8Ve&\u0004\u0013!\u00037pO>,H/\u0016:j\u0003)awnZ8viV\u0013\u0018\u000eI\u0001\fe\u0016$\u0017N]3diV\u0013\u0018.\u0001\u0007sK\u0012L'/Z2u+JL\u0007%A\u000bq_N$Hj\\4pkR\u0014V\rZ5sK\u000e$XK]5\u0002-A|7\u000f\u001e'pO>,HOU3eSJ,7\r^+sS\u0002\naB]8mKN\u001cE.Y5n\u001d\u0006lW-A\bs_2,7o\u00117bS6t\u0015-\\3!\u0003E)8/\u001a:OC6,7\t\\1j[:\u000bW.Z\u0001\u0013kN,'OT1nK\u000ec\u0017-[7OC6,\u0007%A\u0007jIR{7.\u001a8K/N\u000bEnZ\u0001\u000fS\u0012$vn[3o\u0015^\u001b\u0016\t\\4!\u000351W\u000f\u001c7OC6,7\t\\1j[\u0006qa-\u001e7m\u001d\u0006lWm\u00117bS6\u0004\u0013AC3nC&d7\t\\1j[\u0006YQ-\\1jY\u000ec\u0017-[7!\u0003Q\tG\rZ5uS>t\u0017\r\u001c)be\u0006lW\r^3sgV\u0011\u00111\u0015\t\t\u0003K\u000by+!\u0004\u000246\u0011\u0011q\u0015\u0006\u0005\u0003S\u000bY+\u0001\u0003vi&d'BAAW\u0003\u0011Q\u0017M^1\n\t\u0005E\u0016q\u0015\u0002\u0004\u001b\u0006\u0004\b\u0003BA[\u0003wk!!a.\u000b\t\u0005e\u00161V\u0001\u0005Y\u0006tw-\u0003\u0003\u0002>\u0006]&AB(cU\u0016\u001cG/A\u000bbI\u0012LG/[8oC2\u0004\u0016M]1nKR,'o\u001d\u0011\u0002#\u0005\u001c7-Z:t)>\\WM\\%tgV,'/\u0001\nbG\u000e,7o\u001d+pW\u0016t\u0017j]:vKJ\u0004\u0013aE1dG\u0016\u001c8\u000fV8lK:\fU\u000fZ5f]\u000e,\u0017\u0001F1dG\u0016\u001c8\u000fV8lK:\fU\u000fZ5f]\u000e,\u0007%A\tbG\u000e,7o\u001d+pW\u0016t7*Z=Ve&\f!#Y2dKN\u001cHk\\6f].+\u00170\u0016:jA\u0005\t\u0012mY2fgN$vn[3o\u0015^\u001b\u0016\t\\4\u0002%\u0005\u001c7-Z:t)>\\WM\u001c&X'\u0006cw\rI\u0001\u0015C\u000e\u001cWm]:U_.,gnU3de\u0016$8*Z=\u0002+\u0005\u001c7-Z:t)>\\WM\\*fGJ,GoS3zA\u0005qQ\r\u001f;fe:\fGn\u00187pO&t\u0017aD3yi\u0016\u0014h.\u00197`Y><\u0017N\u001c\u0011\u0002-1|w-\u001b8NKRDw\u000e\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:\fq\u0003\\8hS:lU\r\u001e5pI\u0012+7o\u0019:jaRLwN\u001c\u0011\u0002\u0013A\u0014x\u000e_=I_N$\u0018A\u00039s_bL\bj\\:uA\u0005I\u0001O]8ysB{'\u000f^\u000b\u0003\u0003K\u0004B!!.\u0002h&!\u0011\u0011^A\\\u0005\u001dIe\u000e^3hKJ\fQ\u0002\u001d:pqf\u0004vN\u001d;`I\u0015\fH\u0003BA \u0003_D\u0011\"a\u0012M\u0003\u0003\u0005\r!!:\u0002\u0015A\u0014x\u000e_=Q_J$\b%A\u0002ko.,\"!a>\u0011\t\u0005e(QA\u0007\u0003\u0003wTA!a=\u0002~*!\u0011q B\u0001\u0003\u0011Qwn]3\u000b\u0007\t\rQ-\u0001\u0005oS6\u0014Wo\u001d3t\u0013\u0011\u00119!a?\u0003\u0007);6*A\u0004ko.|F%Z9\u0015\t\u0005}\"Q\u0002\u0005\n\u0003\u000fz\u0015\u0011!a\u0001\u0003o\fAA[<lA\u000511oY8qKN,\"A!\u0006\u0011\r\u0005\u0015&qCA\u0007\u0013\u0011\u0011I\"a*\u0003\t1K7\u000f^\u0001\u000bg\u000e|\u0007/Z:`I\u0015\fH\u0003BA \u0005?A\u0011\"a\u0012S\u0003\u0003\u0005\rA!\u0006\u0002\u000fM\u001cw\u000e]3tA\u0005\tr-\u001a;TiJLgn\u001a)s_B,'\u000f^=\u0015\u0011\u00055!q\u0005B\u0015\u0005[AQa\u001c+A\u0002ADqAa\u000bU\u0001\u0004\ti!\u0001\u0003oC6,\u0007b\u0002B\u0018)\u0002\u0007\u0011QB\u0001\rI\u00164\u0017-\u001e7u-\u0006dW/Z\u0001\u000fO\u0016$\u0018J\u001c;Qe>\u0004XM\u001d;z)!\t)O!\u000e\u00038\te\u0002\"B8V\u0001\u0004\u0001\bb\u0002B\u0016+\u0002\u0007\u0011Q\u0002\u0005\b\u0005_)\u0006\u0019AAs\u0003M9W\r^#oG>$W\rZ+sSN#(/\u001b8h)\u0011\tiAa\u0010\t\u000f\t\u0005c\u000b1\u0001\u0002\u000e\u0005\u0019QO]5\u0002'\u001d,G\u000fR3d_\u0012,G-\u0016:j'R\u0014\u0018N\\4\u0015\t\t\u001d#1\n\t\u0005\u0003k\u0013I%\u0003\u0003\u0002 \u0005]\u0006b\u0002B!/\u0002\u0007\u0011QB\u0001\u0016O\u0016$8\u000b\u001e:j]\u001ed\u0015n\u001d;Qe>\u0004XM\u001d;z)!\u0011)B!\u0015\u0003T\tU\u0003\"B8Y\u0001\u0004\u0001\bb\u0002B\u00161\u0002\u0007\u0011Q\u0002\u0005\b\u0005_A\u0006\u0019\u0001B\u000b\u000399W\r^'baB\u0013x\u000e]3sif$\u0002\"a)\u0003\\\tu#q\f\u0005\u0006_f\u0003\r\u0001\u001d\u0005\b\u0005WI\u0006\u0019AA\u0007\u0011\u001d\u0011y#\u0017a\u0001\u0003G\u0003")
public class OidcConfig {
    private final String registrationId;
    private final String clientId;
    private final String clientSecret;
    private final String clientAuthMethod;
    private final String clientAuthJWSAlg;
    private final String tokenKeyId;
    private String keyStorePath;
    private String keyStorePassword;
    private String keyStoreType;
    private final String keyAlias;
    private final String keyPassword;
    private final String defaultKeyStorePath;
    private final String defaultKeyStorePassword;
    private final String issuer;
    private final String jwks_uri;
    private final String accessTokenUri;
    private final String userAuthorizationUri;
    private final String logoutUri;
    private final String redirectUri;
    private final String postLogoutRedirectUri;
    private final String rolesClaimName;
    private final String userNameClaimName;
    private final String idTokenJWSAlg;
    private final String fullNameClaim;
    private final String emailClaim;
    private final Map<String, Object> additionalParameters;
    private final String accessTokenIssuer;
    private final String accessTokenAudience;
    private final String accessTokenKeyUri;
    private final String accessTokenJWSAlg;
    private final String accessTokenSecretKey;
    private final String external_login;
    private final String loginMethodDescription;
    private final String proxyHost;
    private Integer proxyPort;
    private JWK jwk;
    private List<String> scopes;

    public String registrationId() {
        return this.registrationId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public String clientAuthMethod() {
        return this.clientAuthMethod;
    }

    public String clientAuthJWSAlg() {
        return this.clientAuthJWSAlg;
    }

    public String tokenKeyId() {
        return this.tokenKeyId;
    }

    public String keyStorePath() {
        return this.keyStorePath;
    }

    public void keyStorePath_$eq(String x$1) {
        this.keyStorePath = x$1;
    }

    public String keyStorePassword() {
        return this.keyStorePassword;
    }

    public void keyStorePassword_$eq(String x$1) {
        this.keyStorePassword = x$1;
    }

    public String keyStoreType() {
        return this.keyStoreType;
    }

    public void keyStoreType_$eq(String x$1) {
        this.keyStoreType = x$1;
    }

    public String keyAlias() {
        return this.keyAlias;
    }

    public String keyPassword() {
        return this.keyPassword;
    }

    public String defaultKeyStorePath() {
        return this.defaultKeyStorePath;
    }

    public String defaultKeyStorePassword() {
        return this.defaultKeyStorePassword;
    }

    public String issuer() {
        return this.issuer;
    }

    public String jwks_uri() {
        return this.jwks_uri;
    }

    public String accessTokenUri() {
        return this.accessTokenUri;
    }

    public String userAuthorizationUri() {
        return this.userAuthorizationUri;
    }

    public String logoutUri() {
        return this.logoutUri;
    }

    public String redirectUri() {
        return this.redirectUri;
    }

    public String postLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public String rolesClaimName() {
        return this.rolesClaimName;
    }

    public String userNameClaimName() {
        return this.userNameClaimName;
    }

    public String idTokenJWSAlg() {
        return this.idTokenJWSAlg;
    }

    public String fullNameClaim() {
        return this.fullNameClaim;
    }

    public String emailClaim() {
        return this.emailClaim;
    }

    public Map<String, Object> additionalParameters() {
        return this.additionalParameters;
    }

    public String accessTokenIssuer() {
        return this.accessTokenIssuer;
    }

    public String accessTokenAudience() {
        return this.accessTokenAudience;
    }

    public String accessTokenKeyUri() {
        return this.accessTokenKeyUri;
    }

    public String accessTokenJWSAlg() {
        return this.accessTokenJWSAlg;
    }

    public String accessTokenSecretKey() {
        return this.accessTokenSecretKey;
    }

    public String external_login() {
        return this.external_login;
    }

    public String loginMethodDescription() {
        return this.loginMethodDescription;
    }

    public String proxyHost() {
        return this.proxyHost;
    }

    public Integer proxyPort() {
        return this.proxyPort;
    }

    public void proxyPort_$eq(Integer x$1) {
        this.proxyPort = x$1;
    }

    public JWK jwk() {
        return this.jwk;
    }

    public void jwk_$eq(JWK x$1) {
        this.jwk = x$1;
    }

    public List<String> scopes() {
        return this.scopes;
    }

    public void scopes_$eq(List<String> x$1) {
        this.scopes = x$1;
    }

    private String getStringProperty(Config config, String name, String defaultValue) {
        String string;
        try {
            string = config.getString(name);
        }
        catch (ConfigException.Missing missing) {
            string = defaultValue;
        }
        return string;
    }

    private Integer getIntProperty(Config config, String name, Integer defaultValue) {
        Integer n;
        try {
            n = Predef$.MODULE$.int2Integer(config.getInt(name));
        }
        catch (ConfigException.Missing missing) {
            n = defaultValue;
        }
        return n;
    }

    private String getEncodedUriString(String uri) {
        String string;
        try {
            string = URI.create(uri).toASCIIString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = UriComponentsBuilder.fromUriString((String)uri).build().toUri().toASCIIString();
        }
        return string;
    }

    private String getDecodedUriString(String uri) {
        String string;
        try {
            string = URLDecoder.decode(uri, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(String.format("Cannot decode value [%s] with 'utf-8' charset", uri));
        }
        return string;
    }

    private List<String> getStringListProperty(Config config, String name, List<String> defaultValue) {
        List<String> list;
        try {
            list = config.getStringList(name);
        }
        catch (ConfigException.Missing missing) {
            list = defaultValue;
        }
        return list;
    }

    private Map<String, Object> getMapProperty(Config config, String name, Map<String, Object> defaultValue) {
        Map map;
        try {
            map = config.getObject(name).unwrapped();
        }
        catch (ConfigException.Missing missing) {
            map = defaultValue;
        }
        return map;
    }

    public OidcConfig(Config config, ServerConfiguration serverConfiguration) {
        this.registrationId = "xl-deploy";
        this.clientId = config.getString("deploy.security.auth.providers.oidc.clientId");
        this.clientSecret = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientSecret", "");
        this.clientAuthMethod = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthMethod", "client_secret_post");
        this.clientAuthJWSAlg = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.jwsAlg", MacAlgorithm.HS256.getName());
        this.tokenKeyId = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.tokenKeyId", "");
        this.keyStorePath = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.keyStore.path", "");
        this.keyStorePassword = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.keyStore.password", "");
        this.keyStoreType = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.keyStore.type", "");
        this.keyAlias = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.key.alias", "");
        this.keyPassword = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.key.password", "");
        this.defaultKeyStorePath = serverConfiguration.getKeyStorePath();
        this.defaultKeyStorePassword = serverConfiguration.getKeyStorePassword();
        this.issuer = this.getDecodedUriString(config.getString("deploy.security.auth.providers.oidc.issuer"));
        this.jwks_uri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.keyRetrievalUri", ""));
        this.accessTokenUri = this.getDecodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.accessTokenUri", ""));
        this.userAuthorizationUri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.userAuthorizationUri", ""));
        this.logoutUri = this.getDecodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.logoutUri", ""));
        this.redirectUri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.redirectUri", serverConfiguration.getServerUrl() + "login/external-login"));
        this.postLogoutRedirectUri = this.getStringProperty(config, "deploy.security.auth.providers.oidc.postLogoutRedirectUri", this.redirectUri());
        this.rolesClaimName = config.getString("deploy.security.auth.providers.oidc.rolesClaimName");
        this.userNameClaimName = config.getString("deploy.security.auth.providers.oidc.userNameClaimName");
        this.idTokenJWSAlg = this.getStringProperty(config, "deploy.security.auth.providers.oidc.idTokenJWSAlg", SignatureAlgorithm.RS256.getName());
        this.fullNameClaim = this.getStringProperty(config, "deploy.security.auth.providers.oidc.fullNameClaim", "");
        this.emailClaim = this.getStringProperty(config, "deploy.security.auth.providers.oidc.emailClaim", "");
        this.additionalParameters = this.getMapProperty(config, "deploy.security.auth.providers.oidc.additionalParameters", new HashMap<String, Object>());
        this.accessTokenIssuer = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.issuer", "");
        this.accessTokenAudience = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.audience", "");
        this.accessTokenKeyUri = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.keyRetrievalUri", "");
        this.accessTokenJWSAlg = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.jwsAlg", SignatureAlgorithm.RS256.getName());
        this.accessTokenSecretKey = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.secretKey", "");
        this.external_login = "/oauth2/authorization/" + this.registrationId();
        this.loginMethodDescription = this.getStringProperty(config, "deploy.security.auth.providers.oidc.loginMethodDescription", "External login (OpenID Connect)");
        this.proxyHost = this.getStringProperty(config, "deploy.security.auth.providers.oidc.proxyHost", null);
        this.proxyPort = this.getIntProperty(config, "deploy.security.auth.providers.oidc.proxyPort", null);
        this.scopes = this.getStringListProperty(config, "deploy.security.auth.providers.oidc.scopes", (List<String>)new ArrayList<String>(null){
            {
                this.add("openid");
            }
        });
    }
}

