package com.xebialabs.xldeploy.authentication.oidc.policy.impl

import com.xebialabs.deployit.security.policy.UserProfileCreationPolicy
import com.xebialabs.deployit.service.profile.XldUserProfileServiceHolder
import org.slf4j.{Logger, LoggerFactory}
import org.springframework.security.core.Authentication
import org.springframework.security.oauth2.core.oidc.user.OidcUser

import java.util

class OidcUserProfileCreationPolicy(emailClaim: String,
                                    fullNameClaim: String
                                   ) extends UserProfileCreationPolicy {

  private val logger: Logger = LoggerFactory.getLogger(classOf[OidcUserProfileCreationPolicy])

  override def policyApplies(authentication: Authentication): Boolean =
    authentication != null && authentication.getPrincipal != null && authentication.getPrincipal.isInstanceOf[OidcUser]

  override def order(): Int = 10

  override def createProfile(authentication: Authentication): Unit = {
    if (authentication == null || authentication.getPrincipal == null) {
      logger.info("Authentication or principal is null")
      return
    }
    if (!authentication.getPrincipal.isInstanceOf[OidcUser]) {
      logger.info("Principal is not an instance of OidcUser")
      return
    }
      val userName = authentication.getName
      val claims = authentication.getPrincipal.asInstanceOf[OidcUser].getClaims
      val email = extractClaimAsString(emailClaim, claims)
      val name = extractClaimAsString(fullNameClaim, claims)
      logger.info(s"Handling OIDC User ${authentication.getName} LoginEvent")
      XldUserProfileServiceHolder.getXldUserProfileService.createOrUpdateUserProfile(name, email, userName)
  }

  private def extractClaimAsString(field: String, data: util.Map[String, AnyRef]): String = {
    val v: String = data.get(field).asInstanceOf[String]
    if (v == null) {
      logger.info("Did not receive {} field from OIDC provider", field)
      return ""
    }
    v
  }



}