/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.policy.impl;

import com.xebialabs.deployit.security.policy.UserProfileCreationPolicy;
import com.xebialabs.deployit.service.profile.XldUserProfileServiceHolder$;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005A4AAC\u0006\u00015!A!\u0006\u0001B\u0001B\u0003%1\u0006\u0003\u00057\u0001\t\u0005\t\u0015!\u0003,\u0011\u00159\u0004\u0001\"\u00019\u0011\u001di\u0004A1A\u0005\nyBaa\u0012\u0001!\u0002\u0013y\u0004\"\u0002%\u0001\t\u0003J\u0005\"B,\u0001\t\u0003B\u0006\"\u0002/\u0001\t\u0003j\u0006\"\u00022\u0001\t\u0013\u0019'!H(jI\u000e,6/\u001a:Qe>4\u0017\u000e\\3De\u0016\fG/[8o!>d\u0017nY=\u000b\u00051i\u0011\u0001B5na2T!AD\b\u0002\rA|G.[2z\u0015\t\u0001\u0012#\u0001\u0003pS\u0012\u001c'B\u0001\n\u0014\u00039\tW\u000f\u001e5f]RL7-\u0019;j_:T!\u0001F\u000b\u0002\u0011adG-\u001a9m_fT!AF\f\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\r\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Y\u0012\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0003E!j\u0011a\t\u0006\u0003\u001d\u0011R!!\n\u0014\u0002\u0011M,7-\u001e:jifT!aJ\u000b\u0002\u0011\u0011,\u0007\u000f\\8zSRL!!K\u0012\u00033U\u001bXM\u001d)s_\u001aLG.Z\"sK\u0006$\u0018n\u001c8Q_2L7-_\u0001\u000bK6\f\u0017\u000e\\\"mC&l\u0007C\u0001\u00174\u001d\ti\u0013\u0007\u0005\u0002/;5\tqF\u0003\u000213\u00051AH]8pizJ!AM\u000f\u0002\rA\u0013X\rZ3g\u0013\t!TG\u0001\u0004TiJLgn\u001a\u0006\u0003eu\tQBZ;mY:\u000bW.Z\"mC&l\u0017A\u0002\u001fj]&$h\bF\u0002:wq\u0002\"A\u000f\u0001\u000e\u0003-AQAK\u0002A\u0002-BQAN\u0002A\u0002-\na\u0001\\8hO\u0016\u0014X#A \u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015!B:mMRR'\"\u0001#\u0002\u0007=\u0014x-\u0003\u0002G\u0003\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0007q_2L7-_!qa2LWm\u001d\u000b\u0003\u00156\u0003\"\u0001H&\n\u00051k\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006%\u0019\u0001\rA\u0014\t\u0003\u001fVk\u0011\u0001\u0015\u0006\u0003#J\u000bAaY8sK*\u0011Qe\u0015\u0006\u0003)\u000e\u000bqb\u001d9sS:<gM]1nK^|'o[\u0005\u0003-B\u0013a\"Q;uQ\u0016tG/[2bi&|g.A\u0003pe\u0012,'\u000fF\u0001Z!\ta\",\u0003\u0002\\;\t\u0019\u0011J\u001c;\u0002\u001b\r\u0014X-\u0019;f!J|g-\u001b7f)\tq\u0016\r\u0005\u0002\u001d?&\u0011\u0001-\b\u0002\u0005+:LG\u000fC\u0003\u0013\u0011\u0001\u0007a*\u0001\u000bfqR\u0014\u0018m\u0019;DY\u0006LW.Q:TiJLgn\u001a\u000b\u0004W\u00114\u0007\"B3\n\u0001\u0004Y\u0013!\u00024jK2$\u0007\"B4\n\u0001\u0004A\u0017\u0001\u00023bi\u0006\u0004B!\u001b8,75\t!N\u0003\u0002lY\u0006!Q\u000f^5m\u0015\u0005i\u0017\u0001\u00026bm\u0006L!a\u001c6\u0003\u00075\u000b\u0007\u000f")
public class OidcUserProfileCreationPolicy
implements UserProfileCreationPolicy {
    private final String emailClaim;
    private final String fullNameClaim;
    private final Logger logger;

    private Logger logger() {
        return this.logger;
    }

    public boolean policyApplies(Authentication authentication) {
        return authentication != null && authentication.getPrincipal() != null && authentication.getPrincipal() instanceof OidcUser;
    }

    public int order() {
        return 10;
    }

    public void createProfile(Authentication authentication) {
        if (authentication == null || authentication.getPrincipal() == null) {
            this.logger().info("Authentication or principal is null");
            return;
        }
        if (!(authentication.getPrincipal() instanceof OidcUser)) {
            this.logger().info("Principal is not an instance of OidcUser");
            return;
        }
        String userName = authentication.getName();
        Map claims = ((OidcUser)authentication.getPrincipal()).getClaims();
        String email = this.extractClaimAsString(this.emailClaim, claims);
        String name = this.extractClaimAsString(this.fullNameClaim, claims);
        this.logger().info("Handling OIDC User " + authentication.getName() + " LoginEvent");
        XldUserProfileServiceHolder$.MODULE$.getXldUserProfileService().createOrUpdateUserProfile(name, email, userName);
    }

    private String extractClaimAsString(String field, Map<String, Object> data) {
        String v = (String)data.get(field);
        if (v == null) {
            this.logger().info("Did not receive {} field from OIDC provider", (Object)field);
            return "";
        }
        return v;
    }

    public OidcUserProfileCreationPolicy(String emailClaim, String fullNameClaim) {
        this.emailClaim = emailClaim;
        this.fullNameClaim = fullNameClaim;
        this.logger = LoggerFactory.getLogger(OidcUserProfileCreationPolicy.class);
    }
}

