/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.authentication.oidc.conf;

import com.nimbusds.jose.jwk.JWK;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.xebialabs.deployit.ServerConfiguration;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.web.util.UriComponentsBuilder;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t\u0005d\u0001\u0002.\\\u0001!D\u0001b\u001c\u0001\u0003\u0002\u0003\u0006I\u0001\u001d\u0005\to\u0002\u0011\t\u0011)A\u0005q\")a\u0010\u0001C\u0001\u007f\"I\u0011\u0011\u0002\u0001C\u0002\u0013\u0005\u00111\u0002\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u000e!I\u0011Q\u0005\u0001C\u0002\u0013\u0005\u00111\u0002\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u000e!I\u0011\u0011\u0006\u0001C\u0002\u0013\u0005\u00111\u0002\u0005\t\u0003W\u0001\u0001\u0015!\u0003\u0002\u000e!I\u0011Q\u0006\u0001C\u0002\u0013\u0005\u00111\u0002\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002\u000e!I\u0011\u0011\u0007\u0001C\u0002\u0013\u0005\u00111\u0002\u0005\t\u0003g\u0001\u0001\u0015!\u0003\u0002\u000e!I\u0011Q\u0007\u0001C\u0002\u0013\u0005\u00111\u0002\u0005\t\u0003o\u0001\u0001\u0015!\u0003\u0002\u000e!I\u0011\u0011\b\u0001A\u0002\u0013\u0005\u00111\u0002\u0005\n\u0003w\u0001\u0001\u0019!C\u0001\u0003{A\u0001\"!\u0013\u0001A\u0003&\u0011Q\u0002\u0005\n\u0003\u0017\u0002\u0001\u0019!C\u0001\u0003\u0017A\u0011\"!\u0014\u0001\u0001\u0004%\t!a\u0014\t\u0011\u0005M\u0003\u0001)Q\u0005\u0003\u001bA\u0011\"!\u0016\u0001\u0001\u0004%\t!a\u0003\t\u0013\u0005]\u0003\u00011A\u0005\u0002\u0005e\u0003\u0002CA/\u0001\u0001\u0006K!!\u0004\t\u0013\u0005}\u0003A1A\u0005\u0002\u0005-\u0001\u0002CA1\u0001\u0001\u0006I!!\u0004\t\u0013\u0005\r\u0004A1A\u0005\u0002\u0005-\u0001\u0002CA3\u0001\u0001\u0006I!!\u0004\t\u0013\u0005\u001d\u0004A1A\u0005\u0002\u0005-\u0001\u0002CA5\u0001\u0001\u0006I!!\u0004\t\u0013\u0005-\u0004A1A\u0005\u0002\u0005-\u0001\u0002CA7\u0001\u0001\u0006I!!\u0004\t\u0013\u0005=\u0004A1A\u0005\u0002\u0005-\u0001\u0002CA9\u0001\u0001\u0006I!!\u0004\t\u0013\u0005M\u0004A1A\u0005\u0002\u0005-\u0001\u0002CA;\u0001\u0001\u0006I!!\u0004\t\u0013\u0005]\u0004A1A\u0005\u0002\u0005-\u0001\u0002CA=\u0001\u0001\u0006I!!\u0004\t\u0013\u0005m\u0004A1A\u0005\u0002\u0005-\u0001\u0002CA?\u0001\u0001\u0006I!!\u0004\t\u0013\u0005}\u0004A1A\u0005\u0002\u0005-\u0001\u0002CAA\u0001\u0001\u0006I!!\u0004\t\u0013\u0005\r\u0005A1A\u0005\u0002\u0005-\u0001\u0002CAC\u0001\u0001\u0006I!!\u0004\t\u0013\u0005\u001d\u0005A1A\u0005\u0002\u0005-\u0001\u0002CAE\u0001\u0001\u0006I!!\u0004\t\u0013\u0005-\u0005A1A\u0005\u0002\u0005-\u0001\u0002CAG\u0001\u0001\u0006I!!\u0004\t\u0013\u0005=\u0005A1A\u0005\u0002\u0005-\u0001\u0002CAI\u0001\u0001\u0006I!!\u0004\t\u0013\u0005M\u0005A1A\u0005\u0002\u0005-\u0001\u0002CAK\u0001\u0001\u0006I!!\u0004\t\u0013\u0005]\u0005A1A\u0005\u0002\u0005-\u0001\u0002CAM\u0001\u0001\u0006I!!\u0004\t\u0013\u0005m\u0005A1A\u0005\u0002\u0005-\u0001\u0002CAO\u0001\u0001\u0006I!!\u0004\t\u0013\u0005}\u0005A1A\u0005\u0002\u0005\u0005\u0006\u0002CA`\u0001\u0001\u0006I!a)\t\u0013\u0005\u0005\u0007A1A\u0005\u0002\u0005-\u0001\u0002CAb\u0001\u0001\u0006I!!\u0004\t\u0013\u0005\u0015\u0007A1A\u0005\u0002\u0005-\u0001\u0002CAd\u0001\u0001\u0006I!!\u0004\t\u0013\u0005%\u0007A1A\u0005\u0002\u0005-\u0001\u0002CAf\u0001\u0001\u0006I!!\u0004\t\u0013\u00055\u0007A1A\u0005\u0002\u0005-\u0001\u0002CAh\u0001\u0001\u0006I!!\u0004\t\u0013\u0005E\u0007A1A\u0005\u0002\u0005-\u0001\u0002CAj\u0001\u0001\u0006I!!\u0004\t\u0013\u0005U\u0007A1A\u0005\u0002\u0005-\u0001\u0002CAl\u0001\u0001\u0006I!!\u0004\t\u0013\u0005e\u0007A1A\u0005\u0002\u0005-\u0001\u0002CAn\u0001\u0001\u0006I!!\u0004\t\u0013\u0005u\u0007A1A\u0005\u0002\u0005-\u0001\u0002CAp\u0001\u0001\u0006I!!\u0004\t\u0013\u0005\u0005\b\u00011A\u0005\u0002\u0005\r\b\"CAv\u0001\u0001\u0007I\u0011AAw\u0011!\t\t\u0010\u0001Q!\n\u0005\u0015\bbCAz\u0001\u0001\u0007\t\u0019!C\u0001\u0003kD1B!\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003\f!Y!q\u0002\u0001A\u0002\u0003\u0005\u000b\u0015BA|\u0011%\u0011\t\u0002\u0001a\u0001\n\u0003\u0011\u0019\u0002C\u0005\u0003\u001c\u0001\u0001\r\u0011\"\u0001\u0003\u001e!A!\u0011\u0005\u0001!B\u0013\u0011)\u0002C\u0004\u0003$\u0001!IA!\n\t\u000f\tE\u0002\u0001\"\u0003\u00034!9!1\b\u0001\u0005\n\tu\u0002b\u0002B\"\u0001\u0011%!Q\t\u0005\b\u0005\u001b\u0002A\u0011\u0002B(\u0011\u001d\u00119\u0006\u0001C\u0005\u00053\u0012!bT5eG\u000e{gNZ5h\u0015\taV,\u0001\u0003d_:4'B\u00010`\u0003\u0011y\u0017\u000eZ2\u000b\u0005\u0001\f\u0017AD1vi\",g\u000e^5dCRLwN\u001c\u0006\u0003E\u000e\f\u0001\u0002\u001f7eKBdw.\u001f\u0006\u0003I\u0016\f\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0019\f1aY8n\u0007\u0001\u0019\"\u0001A5\u0011\u0005)lW\"A6\u000b\u00031\fQa]2bY\u0006L!A\\6\u0003\r\u0005s\u0017PU3g\u0003\u0019\u0019wN\u001c4jOB\u0011\u0011/^\u0007\u0002e*\u0011qn\u001d\u0006\u0003i\u0016\f\u0001\u0002^=qKN\fg-Z\u0005\u0003mJ\u0014aaQ8oM&<\u0017aE:feZ,'oQ8oM&<WO]1uS>t\u0007CA=}\u001b\u0005Q(BA>d\u0003!!W\r\u001d7ps&$\u0018BA?{\u0005M\u0019VM\u001d<fe\u000e{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q1\u0011\u0011AA\u0003\u0003\u000f\u00012!a\u0001\u0001\u001b\u0005Y\u0006\"B8\u0004\u0001\u0004\u0001\b\"B<\u0004\u0001\u0004A\u0018A\u0004:fO&\u001cHO]1uS>t\u0017\nZ\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u001e9!\u0011\u0011CA\r!\r\t\u0019b[\u0007\u0003\u0003+Q1!a\u0006h\u0003\u0019a$o\\8u}%\u0019\u00111D6\u0002\rA\u0013X\rZ3g\u0013\u0011\ty\"!\t\u0003\rM#(/\u001b8h\u0015\r\tYb[\u0001\u0010e\u0016<\u0017n\u001d;sCRLwN\\%eA\u0005A1\r\\5f]RLE-A\u0005dY&,g\u000e^%eA\u0005a1\r\\5f]R\u001cVm\u0019:fi\u0006i1\r\\5f]R\u001cVm\u0019:fi\u0002\n\u0001c\u00197jK:$\u0018)\u001e;i\u001b\u0016$\bn\u001c3\u0002#\rd\u0017.\u001a8u\u0003V$\b.T3uQ>$\u0007%\u0001\tdY&,g\u000e^!vi\"TukU!mO\u0006\t2\r\\5f]R\fU\u000f\u001e5K/N\u000bEn\u001a\u0011\u0002\u0015Q|7.\u001a8LKfLE-A\u0006u_.,gnS3z\u0013\u0012\u0004\u0013\u0001D6fsN#xN]3QCRD\u0017\u0001E6fsN#xN]3QCRDw\fJ3r)\u0011\ty$!\u0012\u0011\u0007)\f\t%C\u0002\u0002D-\u0014A!\u00168ji\"I\u0011qI\t\u0002\u0002\u0003\u0007\u0011QB\u0001\u0004q\u0012\n\u0014!D6fsN#xN]3QCRD\u0007%\u0001\tlKf\u001cFo\u001c:f!\u0006\u001c8o^8sI\u0006!2.Z=Ti>\u0014X\rU1tg^|'\u000fZ0%KF$B!a\u0010\u0002R!I\u0011q\t\u000b\u0002\u0002\u0003\u0007\u0011QB\u0001\u0012W\u0016L8\u000b^8sKB\u000b7o]<pe\u0012\u0004\u0013\u0001D6fsN#xN]3UsB,\u0017\u0001E6fsN#xN]3UsB,w\fJ3r)\u0011\ty$a\u0017\t\u0013\u0005\u001ds#!AA\u0002\u00055\u0011!D6fsN#xN]3UsB,\u0007%\u0001\u0005lKf\fE.[1t\u0003%YW-_!mS\u0006\u001c\b%A\u0006lKf\u0004\u0016m]:x_J$\u0017\u0001D6fsB\u000b7o]<pe\u0012\u0004\u0013a\u00053fM\u0006,H\u000e^&fsN#xN]3QCRD\u0017\u0001\u00063fM\u0006,H\u000e^&fsN#xN]3QCRD\u0007%A\feK\u001a\fW\u000f\u001c;LKf\u001cFo\u001c:f!\u0006\u001c8o^8sI\u0006AB-\u001a4bk2$8*Z=Ti>\u0014X\rU1tg^|'\u000f\u001a\u0011\u0002\r%\u001c8/^3s\u0003\u001dI7o];fe\u0002\n\u0001B[<lg~+(/[\u0001\nU^\\7oX;sS\u0002\na\"Y2dKN\u001cHk\\6f]V\u0013\u0018.A\bbG\u000e,7o\u001d+pW\u0016tWK]5!\u0003Q)8/\u001a:BkRDwN]5{CRLwN\\+sS\u0006)Ro]3s\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8Ve&\u0004\u0013!\u00037pO>,H/\u0016:j\u0003)awnZ8viV\u0013\u0018\u000eI\u0001\fe\u0016$\u0017N]3diV\u0013\u0018.\u0001\u0007sK\u0012L'/Z2u+JL\u0007%A\u000bq_N$Hj\\4pkR\u0014V\rZ5sK\u000e$XK]5\u0002-A|7\u000f\u001e'pO>,HOU3eSJ,7\r^+sS\u0002\naB]8mKN\u001cE.Y5n\u001d\u0006lW-A\bs_2,7o\u00117bS6t\u0015-\\3!\u0003E)8/\u001a:OC6,7\t\\1j[:\u000bW.Z\u0001\u0013kN,'OT1nK\u000ec\u0017-[7OC6,\u0007%A\u0007jIR{7.\u001a8K/N\u000bEnZ\u0001\u000fS\u0012$vn[3o\u0015^\u001b\u0016\t\\4!\u0003E1W\u000f\u001c7OC6,7\t\\1j[:\u000bW.Z\u0001\u0013MVdGNT1nK\u000ec\u0017-[7OC6,\u0007%\u0001\bf[\u0006LGn\u00117bS6t\u0015-\\3\u0002\u001f\u0015l\u0017-\u001b7DY\u0006LWNT1nK\u0002\nA#\u00193eSRLwN\\1m!\u0006\u0014\u0018-\\3uKJ\u001cXCAAR!!\t)+a,\u0002\u000e\u0005MVBAAT\u0015\u0011\tI+a+\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003[\u000bAA[1wC&!\u0011\u0011WAT\u0005\ri\u0015\r\u001d\t\u0005\u0003k\u000bY,\u0004\u0002\u00028*!\u0011\u0011XAV\u0003\u0011a\u0017M\\4\n\t\u0005u\u0016q\u0017\u0002\u0007\u001f\nTWm\u0019;\u0002+\u0005$G-\u001b;j_:\fG\u000eU1sC6,G/\u001a:tA\u0005\t\u0012mY2fgN$vn[3o\u0013N\u001cX/\u001a:\u0002%\u0005\u001c7-Z:t)>\\WM\\%tgV,'\u000fI\u0001\u0014C\u000e\u001cWm]:U_.,g.Q;eS\u0016t7-Z\u0001\u0015C\u000e\u001cWm]:U_.,g.Q;eS\u0016t7-\u001a\u0011\u0002#\u0005\u001c7-Z:t)>\\WM\\&fsV\u0013\u0018.\u0001\nbG\u000e,7o\u001d+pW\u0016t7*Z=Ve&\u0004\u0013!E1dG\u0016\u001c8\u000fV8lK:TukU!mO\u0006\u0011\u0012mY2fgN$vn[3o\u0015^\u001b\u0016\t\\4!\u0003Q\t7mY3tgR{7.\u001a8TK\u000e\u0014X\r^&fs\u0006)\u0012mY2fgN$vn[3o'\u0016\u001c'/\u001a;LKf\u0004\u0013AD3yi\u0016\u0014h.\u00197`Y><\u0017N\\\u0001\u0010Kb$XM\u001d8bY~cwnZ5oA\u00051Bn\\4j]6+G\u000f[8e\t\u0016\u001c8M]5qi&|g.A\fm_\u001eLg.T3uQ>$G)Z:de&\u0004H/[8oA\u0005I\u0001O]8ys\"{7\u000f^\u0001\u000baJ|\u00070\u001f%pgR\u0004\u0013!\u00039s_bL\bk\u001c:u+\t\t)\u000f\u0005\u0003\u00026\u0006\u001d\u0018\u0002BAu\u0003o\u0013q!\u00138uK\u001e,'/A\u0007qe>D\u0018\u0010U8si~#S-\u001d\u000b\u0005\u0003\u007f\ty\u000fC\u0005\u0002H1\u000b\t\u00111\u0001\u0002f\u0006Q\u0001O]8ysB{'\u000f\u001e\u0011\u0002\u0007)<8.\u0006\u0002\u0002xB!\u0011\u0011 B\u0003\u001b\t\tYP\u0003\u0003\u0002t\u0006u(\u0002BA\u0000\u0005\u0003\tAA[8tK*\u0019!1A3\u0002\u00119LWNY;tINLAAa\u0002\u0002|\n\u0019!jV&\u0002\u000f)<8n\u0018\u0013fcR!\u0011q\bB\u0007\u0011%\t9eTA\u0001\u0002\u0004\t90\u0001\u0003ko.\u0004\u0013AB:d_B,7/\u0006\u0002\u0003\u0016A1\u0011Q\u0015B\f\u0003\u001bIAA!\u0007\u0002(\n!A*[:u\u0003)\u00198m\u001c9fg~#S-\u001d\u000b\u0005\u0003\u007f\u0011y\u0002C\u0005\u0002HI\u000b\t\u00111\u0001\u0003\u0016\u000591oY8qKN\u0004\u0013!E4fiN#(/\u001b8h!J|\u0007/\u001a:usRA\u0011Q\u0002B\u0014\u0005S\u0011i\u0003C\u0003p)\u0002\u0007\u0001\u000fC\u0004\u0003,Q\u0003\r!!\u0004\u0002\t9\fW.\u001a\u0005\b\u0005_!\u0006\u0019AA\u0007\u00031!WMZ1vYR4\u0016\r\\;f\u000399W\r^%oiB\u0013x\u000e]3sif$\u0002\"!:\u00036\t]\"\u0011\b\u0005\u0006_V\u0003\r\u0001\u001d\u0005\b\u0005W)\u0006\u0019AA\u0007\u0011\u001d\u0011y#\u0016a\u0001\u0003K\f1cZ3u\u000b:\u001cw\u000eZ3e+JL7\u000b\u001e:j]\u001e$B!!\u0004\u0003@!9!\u0011\t,A\u0002\u00055\u0011aA;sS\u0006\u0019r-\u001a;EK\u000e|G-\u001a3Ve&\u001cFO]5oOR!!q\tB&!\u0011\t)L!\u0013\n\t\u0005}\u0011q\u0017\u0005\b\u0005\u0003:\u0006\u0019AA\u0007\u0003U9W\r^*ue&tw\rT5tiB\u0013x\u000e]3sif$\u0002B!\u0006\u0003R\tM#Q\u000b\u0005\u0006_b\u0003\r\u0001\u001d\u0005\b\u0005WA\u0006\u0019AA\u0007\u0011\u001d\u0011y\u0003\u0017a\u0001\u0005+\tabZ3u\u001b\u0006\u0004\bK]8qKJ$\u0018\u0010\u0006\u0005\u0002$\nm#Q\fB0\u0011\u0015y\u0017\f1\u0001q\u0011\u001d\u0011Y#\u0017a\u0001\u0003\u001bAqAa\fZ\u0001\u0004\t\u0019\u000b")
public class OidcConfig {
    private final String registrationId;
    private final String clientId;
    private final String clientSecret;
    private final String clientAuthMethod;
    private final String clientAuthJWSAlg;
    private final String tokenKeyId;
    private String keyStorePath;
    private String keyStorePassword;
    private String keyStoreType;
    private final String keyAlias;
    private final String keyPassword;
    private final String defaultKeyStorePath;
    private final String defaultKeyStorePassword;
    private final String issuer;
    private final String jwks_uri;
    private final String accessTokenUri;
    private final String userAuthorizationUri;
    private final String logoutUri;
    private final String redirectUri;
    private final String postLogoutRedirectUri;
    private final String rolesClaimName;
    private final String userNameClaimName;
    private final String idTokenJWSAlg;
    private final String fullNameClaimName;
    private final String emailClaimName;
    private final Map<String, Object> additionalParameters;
    private final String accessTokenIssuer;
    private final String accessTokenAudience;
    private final String accessTokenKeyUri;
    private final String accessTokenJWSAlg;
    private final String accessTokenSecretKey;
    private final String external_login;
    private final String loginMethodDescription;
    private final String proxyHost;
    private Integer proxyPort;
    private JWK jwk;
    private List<String> scopes;

    public String registrationId() {
        return this.registrationId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public String clientAuthMethod() {
        return this.clientAuthMethod;
    }

    public String clientAuthJWSAlg() {
        return this.clientAuthJWSAlg;
    }

    public String tokenKeyId() {
        return this.tokenKeyId;
    }

    public String keyStorePath() {
        return this.keyStorePath;
    }

    public void keyStorePath_$eq(String x$1) {
        this.keyStorePath = x$1;
    }

    public String keyStorePassword() {
        return this.keyStorePassword;
    }

    public void keyStorePassword_$eq(String x$1) {
        this.keyStorePassword = x$1;
    }

    public String keyStoreType() {
        return this.keyStoreType;
    }

    public void keyStoreType_$eq(String x$1) {
        this.keyStoreType = x$1;
    }

    public String keyAlias() {
        return this.keyAlias;
    }

    public String keyPassword() {
        return this.keyPassword;
    }

    public String defaultKeyStorePath() {
        return this.defaultKeyStorePath;
    }

    public String defaultKeyStorePassword() {
        return this.defaultKeyStorePassword;
    }

    public String issuer() {
        return this.issuer;
    }

    public String jwks_uri() {
        return this.jwks_uri;
    }

    public String accessTokenUri() {
        return this.accessTokenUri;
    }

    public String userAuthorizationUri() {
        return this.userAuthorizationUri;
    }

    public String logoutUri() {
        return this.logoutUri;
    }

    public String redirectUri() {
        return this.redirectUri;
    }

    public String postLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public String rolesClaimName() {
        return this.rolesClaimName;
    }

    public String userNameClaimName() {
        return this.userNameClaimName;
    }

    public String idTokenJWSAlg() {
        return this.idTokenJWSAlg;
    }

    public String fullNameClaimName() {
        return this.fullNameClaimName;
    }

    public String emailClaimName() {
        return this.emailClaimName;
    }

    public Map<String, Object> additionalParameters() {
        return this.additionalParameters;
    }

    public String accessTokenIssuer() {
        return this.accessTokenIssuer;
    }

    public String accessTokenAudience() {
        return this.accessTokenAudience;
    }

    public String accessTokenKeyUri() {
        return this.accessTokenKeyUri;
    }

    public String accessTokenJWSAlg() {
        return this.accessTokenJWSAlg;
    }

    public String accessTokenSecretKey() {
        return this.accessTokenSecretKey;
    }

    public String external_login() {
        return this.external_login;
    }

    public String loginMethodDescription() {
        return this.loginMethodDescription;
    }

    public String proxyHost() {
        return this.proxyHost;
    }

    public Integer proxyPort() {
        return this.proxyPort;
    }

    public void proxyPort_$eq(Integer x$1) {
        this.proxyPort = x$1;
    }

    public JWK jwk() {
        return this.jwk;
    }

    public void jwk_$eq(JWK x$1) {
        this.jwk = x$1;
    }

    public List<String> scopes() {
        return this.scopes;
    }

    public void scopes_$eq(List<String> x$1) {
        this.scopes = x$1;
    }

    private String getStringProperty(Config config, String name, String defaultValue) {
        String string;
        try {
            string = config.getString(name);
        }
        catch (ConfigException.Missing missing) {
            string = defaultValue;
        }
        return string;
    }

    private Integer getIntProperty(Config config, String name, Integer defaultValue) {
        Integer n;
        try {
            n = Predef$.MODULE$.int2Integer(config.getInt(name));
        }
        catch (ConfigException.Missing missing) {
            n = defaultValue;
        }
        return n;
    }

    private String getEncodedUriString(String uri) {
        String string;
        try {
            string = URI.create(uri).toASCIIString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = UriComponentsBuilder.fromUriString((String)uri).build().toUri().toASCIIString();
        }
        return string;
    }

    private String getDecodedUriString(String uri) {
        String string;
        try {
            string = URLDecoder.decode(uri, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(String.format("Cannot decode value [%s] with 'utf-8' charset", uri));
        }
        return string;
    }

    private List<String> getStringListProperty(Config config, String name, List<String> defaultValue) {
        List<String> list;
        try {
            list = config.getStringList(name);
        }
        catch (ConfigException.Missing missing) {
            list = defaultValue;
        }
        return list;
    }

    private Map<String, Object> getMapProperty(Config config, String name, Map<String, Object> defaultValue) {
        Map map;
        try {
            map = config.getObject(name).unwrapped();
        }
        catch (ConfigException.Missing missing) {
            map = defaultValue;
        }
        return map;
    }

    public OidcConfig(Config config, ServerConfiguration serverConfiguration) {
        this.registrationId = "xl-deploy";
        this.clientId = config.getString("deploy.security.auth.providers.oidc.clientId");
        this.clientSecret = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientSecret", "");
        this.clientAuthMethod = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthMethod", "client_secret_post");
        this.clientAuthJWSAlg = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.jwsAlg", MacAlgorithm.HS256.getName());
        this.tokenKeyId = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.tokenKeyId", "");
        this.keyStorePath = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.keyStore.path", "");
        this.keyStorePassword = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.keyStore.password", "");
        this.keyStoreType = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.keyStore.type", "");
        this.keyAlias = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.key.alias", "");
        this.keyPassword = this.getStringProperty(config, "deploy.security.auth.providers.oidc.clientAuthJwt.key.password", "");
        this.defaultKeyStorePath = serverConfiguration.getKeyStorePath();
        this.defaultKeyStorePassword = serverConfiguration.getKeyStorePassword();
        this.issuer = this.getDecodedUriString(config.getString("deploy.security.auth.providers.oidc.issuer"));
        this.jwks_uri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.keyRetrievalUri", ""));
        this.accessTokenUri = this.getDecodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.accessTokenUri", ""));
        this.userAuthorizationUri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.userAuthorizationUri", ""));
        this.logoutUri = this.getDecodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.logoutUri", ""));
        this.redirectUri = this.getEncodedUriString(this.getStringProperty(config, "deploy.security.auth.providers.oidc.redirectUri", serverConfiguration.getServerUrl() + "login/external-login"));
        this.postLogoutRedirectUri = this.getStringProperty(config, "deploy.security.auth.providers.oidc.postLogoutRedirectUri", this.redirectUri());
        this.rolesClaimName = config.getString("deploy.security.auth.providers.oidc.rolesClaimName");
        this.userNameClaimName = config.getString("deploy.security.auth.providers.oidc.userNameClaimName");
        this.idTokenJWSAlg = this.getStringProperty(config, "deploy.security.auth.providers.oidc.idTokenJWSAlg", SignatureAlgorithm.RS256.getName());
        this.fullNameClaimName = this.getStringProperty(config, "deploy.security.auth.providers.oidc.fullNameClaimName", "");
        this.emailClaimName = this.getStringProperty(config, "deploy.security.auth.providers.oidc.emailClaimName", "");
        this.additionalParameters = this.getMapProperty(config, "deploy.security.auth.providers.oidc.additionalParameters", new HashMap<String, Object>());
        this.accessTokenIssuer = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.issuer", "");
        this.accessTokenAudience = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.audience", "");
        this.accessTokenKeyUri = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.keyRetrievalUri", "");
        this.accessTokenJWSAlg = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.jwsAlg", SignatureAlgorithm.RS256.getName());
        this.accessTokenSecretKey = this.getStringProperty(config, "deploy.security.auth.providers.oidc.access-token.secretKey", "");
        this.external_login = "/oauth2/authorization/" + this.registrationId();
        this.loginMethodDescription = this.getStringProperty(config, "deploy.security.auth.providers.oidc.loginMethodDescription", "External login (OpenID Connect)");
        this.proxyHost = this.getStringProperty(config, "deploy.security.auth.providers.oidc.proxyHost", null);
        this.proxyPort = this.getIntProperty(config, "deploy.security.auth.providers.oidc.proxyPort", null);
        this.scopes = this.getStringListProperty(config, "deploy.security.auth.providers.oidc.scopes", (List<String>)new ArrayList<String>(null){
            {
                this.add("openid");
            }
        });
    }
}

