/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.overthere;

import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.credentials.HostCredentials;
import com.xebialabs.deployit.plugin.overthere.BaseValidator;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.cifs.CifsConnectionType;

public final class UsernameValidation {
    private UsernameValidation() {
    }

    public static class Validator
    extends BaseValidator {
        @Override
        protected void validate(Host value, ValidationContext context, String protocol) {
            CifsConnectionType connectionType = (CifsConnectionType)value.getProperty("connectionType");
            HostCredentials hostCredentials = (HostCredentials)value.getProperty("credentials");
            String username = hostCredentials != null ? hostCredentials.getUsername() : (String)value.getProperty("username");
            switch (connectionType) {
                case TELNET: {
                    if (username == null || !username.contains("@")) break;
                    context.error("%s/Telnet host [%s] cannot have a new-style domain username (%s).", new Object[]{protocol, value.getId(), username});
                    break;
                }
                case WINRM_INTERNAL: {
                    if (username == null || !username.contains("\\")) break;
                    context.error("%s/%s host [%s] cannot have an old-style domain username (%s).", new Object[]{protocol, connectionType, value.getId(), username});
                    break;
                }
            }
        }
    }
}

