/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.remoting.vars;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.xebialabs.deployit.io.ArtifactFileUtils;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StagedFile;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.remoting.vars.DerivedProperty;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VarsConverter {
    private static final String GENERATED_VARIABLE_PREFIX = "_pv";
    private static final String PROPERTIES_VARIABLE_NAME = "_properties";
    public static final String STAGED_FILE_VARIABLE_NAME_PREFIX = "_stagedFile";
    private static final char EMBEDDED_OBJECT_SEPARATOR = '_';
    private static final String FILE_PROPERTY_NAME = "file";
    private OverthereConnection connection;
    private Map<String, Object> vars;
    private Class<? extends Annotation> annotationClass;
    private Map<Object, String> alreadyConvertedCis = Maps.newIdentityHashMap();
    private int nextVarNumber = 1;
    private List<String> lines = Lists.newArrayList();
    protected boolean maskPasswords;
    protected boolean exposePasswordPropertiesOnHosts;
    private boolean uploadArtifactData = true;
    private ExecutionContext executionContext;
    private static final Logger logger = LoggerFactory.getLogger(VarsConverter.class);

    protected VarsConverter(OverthereConnection connection, Map<String, Object> vars, Class<? extends Annotation> annotationClass, boolean maskPasswords, boolean exposePasswordPropertiesOnHosts) {
        this.connection = connection;
        this.vars = vars;
        this.annotationClass = annotationClass;
        this.maskPasswords = maskPasswords;
        this.exposePasswordPropertiesOnHosts = exposePasswordPropertiesOnHosts;
    }

    protected VarsConverter(OverthereConnection connection, Map<String, Object> vars, boolean maskPasswords, boolean exposePasswordPropertiesOnHosts) {
        this(connection, vars, DerivedProperty.class, maskPasswords, exposePasswordPropertiesOnHosts);
    }

    protected VarsConverter(OverthereConnection connection, Map<String, Object> vars, Class<? extends Annotation> annotationClass, boolean maskPasswords) {
        this(connection, vars, annotationClass, maskPasswords, true);
    }

    public List<String> convert() {
        logger.debug("Starting vars conversion");
        TreeSet sortedKeys = Sets.newTreeSet(this.vars.keySet());
        for (String varName : sortedKeys) {
            Object varValue = this.vars.get(varName);
            logger.debug("Converting variable [{}]", (Object)varName);
            this.convertVariable(varName, varValue);
        }
        logger.debug("Finished vars conversion");
        return this.lines;
    }

    public void setUploadArtifactData(boolean uploadArtifactData) {
        this.uploadArtifactData = uploadArtifactData;
    }

    private void convertVariable(String variableName, Object variableValue) {
        if (variableValue == null) {
            this.setNullVariable(variableName);
        } else if (variableValue instanceof StagedFile) {
            Preconditions.checkArgument((boolean)variableName.endsWith(STAGED_FILE_VARIABLE_NAME_PREFIX), (String)"Staged file variable name [%s] must by prefixed with [%s]", (Object)variableName, (Object)STAGED_FILE_VARIABLE_NAME_PREFIX);
        } else if (variableValue instanceof Boolean) {
            this.setBooleanVariable(variableName, (Boolean)variableValue);
        } else if (variableValue instanceof Integer) {
            this.setIntegerVariable(variableName, (Integer)variableValue);
        } else if (variableValue instanceof Long) {
            this.setLongVariable(variableName, (Long)variableValue);
        } else if (variableValue instanceof ConfigurationItem) {
            this.alreadyConvertedCis.put(variableValue, variableName);
            this.appendConfigurationItemVar(variableName, (ConfigurationItem)variableValue);
        } else if (variableValue instanceof Collection) {
            this.setCollectionOfStringsVariable(variableName, (Collection)variableValue);
        } else {
            this.setStringVariable(variableName, variableValue.toString());
        }
    }

    private void appendConfigurationItemVar(String varName, ConfigurationItem item) {
        Descriptor d = DescriptorRegistry.getDescriptor((Type)item.getType());
        this.startCreateObject(varName);
        this.appendEmbeddedObjectDefinitions(varName, d);
        this.appendConfigurationItemVarMetaData(varName, item, d);
        this.appendRegularPropertiesToConfigurationItemVar(varName, item, d);
        this.appendDerivedPropertiesToConfigurationItemVar(varName, item);
        this.appendArtifactPropertiesToConfigurationItemVar(varName, item);
        this.endCreateObject(varName);
    }

    private void appendEmbeddedObjectDefinitions(String varName, Descriptor descriptor) {
        Multimap<String, String> embeddedObjects = VarsConverter.getEmbeddedObjects(varName, descriptor);
        this.createEmbeddedObjects(embeddedObjects);
    }

    private static Multimap<String, String> getEmbeddedObjects(String varName, Descriptor descriptor) {
        TreeMultimap embeddedObjects = TreeMultimap.create();
        for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            if (!VarsConverter.isEmbeddedObjectProperty(pd)) continue;
            embeddedObjects.put((Object)(varName + "." + VarsConverter.getEmbeddedObjectName(pd)), (Object)VarsConverter.getEmbeddedPropertyName(pd));
        }
        for (String embeddedObjectName : embeddedObjects.keySet()) {
            String embeddedObjectParentName = embeddedObjectName.substring(0, embeddedObjectName.lastIndexOf("."));
            if (!embeddedObjects.containsKey((Object)embeddedObjectParentName)) continue;
            String nameOfEmbeddedObjectWithinParent = embeddedObjectName.substring(embeddedObjectName.lastIndexOf(".") + 1);
            embeddedObjects.get((Object)embeddedObjectParentName).add(nameOfEmbeddedObjectWithinParent);
        }
        return embeddedObjects;
    }

    private void createEmbeddedObjects(Multimap<String, String> objectAttributesKeyedByObjectName) {
        for (String embeddedObjectName : objectAttributesKeyedByObjectName.keySet()) {
            int lastDot = embeddedObjectName.lastIndexOf(46);
            this.createObjectAndSetObjectProperty(embeddedObjectName.substring(0, lastDot), embeddedObjectName.substring(lastDot + 1));
            this.setCollectionOfStringsProperty(embeddedObjectName, PROPERTIES_VARIABLE_NAME, objectAttributesKeyedByObjectName.get((Object)embeddedObjectName));
        }
    }

    private static boolean isEmbeddedObjectProperty(PropertyDescriptor pd) {
        return VarsConverter.getLastIndexOfEmbeddedObjectSeparator(pd) != -1;
    }

    private static String getEmbeddedObjectName(PropertyDescriptor pd) {
        return pd.getName().substring(0, VarsConverter.getLastIndexOfEmbeddedObjectSeparator(pd)).replace('_', '.');
    }

    private static String getEmbeddedPropertyName(PropertyDescriptor pd) {
        return pd.getName().substring(VarsConverter.getLastIndexOfEmbeddedObjectSeparator(pd) + 1);
    }

    private static int getLastIndexOfEmbeddedObjectSeparator(PropertyDescriptor pd) {
        return pd.getName().lastIndexOf(95);
    }

    private void appendConfigurationItemVarMetaData(String varName, ConfigurationItem item, Descriptor d) {
        this.setStringProperty(varName, "id", item.getId());
        this.setStringProperty(varName, "name", item.getName());
        this.setStringProperty(varName, "type", item.getType().toString());
        TreeSet properties = Sets.newTreeSet();
        properties.add("id");
        properties.add("name");
        properties.add("type");
        for (PropertyDescriptor pd : d.getPropertyDescriptors()) {
            String propertyName = !VarsConverter.isEmbeddedObjectProperty(pd) ? pd.getName() : pd.getName().substring(0, pd.getName().indexOf(95));
            properties.add(propertyName);
        }
        Set methodsAnnotatedWith = Scannit.getInstance().getMethodsAnnotatedWith(this.annotationClass);
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)item.getType());
        for (Method method : methodsAnnotatedWith) {
            if (!descriptor.isAssignableTo(method.getDeclaringClass())) continue;
            properties.add(this.getDerivedPropertyName(method));
        }
        this.setCollectionOfStringsProperty(varName, PROPERTIES_VARIABLE_NAME, properties);
    }

    protected String getDerivedPropertyName(Method method) {
        try {
            Annotation derivedProperty = method.getAnnotation(this.annotationClass);
            Method valueMethod = this.annotationClass.getMethod("value", new Class[0]);
            return (String)valueMethod.invoke((Object)derivedProperty, new Object[0]);
        }
        catch (Exception exc) {
            throw new RuntimeException("Cannot get name of @DerivedProperty " + method, exc);
        }
    }

    private void appendRegularPropertiesToConfigurationItemVar(String varName, ConfigurationItem item, Descriptor d) {
        block11: for (PropertyDescriptor pd : d.getPropertyDescriptors()) {
            String propertyName;
            String objectName;
            if (!VarsConverter.isEmbeddedObjectProperty(pd)) {
                objectName = varName;
                propertyName = pd.getName();
            } else {
                objectName = varName + "." + VarsConverter.getEmbeddedObjectName(pd);
                propertyName = VarsConverter.getEmbeddedPropertyName(pd);
            }
            Object propertyValue = pd.get(item);
            switch (pd.getKind()) {
                case BOOLEAN: {
                    if (propertyValue == null) {
                        this.setNullProperty(objectName, propertyName);
                        continue block11;
                    }
                    if (!(propertyValue instanceof Boolean)) {
                        throw new IllegalStateException("Property " + pd + " is not a Boolean but a " + propertyValue.getClass().getName());
                    }
                    this.setBooleanProperty(objectName, propertyName, (Boolean)propertyValue);
                    continue block11;
                }
                case INTEGER: {
                    if (propertyValue == null) {
                        this.setNullProperty(objectName, propertyName);
                        continue block11;
                    }
                    if (!(propertyValue instanceof Integer)) {
                        throw new IllegalStateException("Property " + pd + " is not an Integer but a " + propertyValue.getClass().getName());
                    }
                    this.setIntegerProperty(objectName, propertyName, (Integer)propertyValue);
                    continue block11;
                }
                case STRING: 
                case ENUM: {
                    if (propertyValue == null) {
                        this.setNullProperty(objectName, propertyName);
                        continue block11;
                    }
                    if (pd.isPassword()) {
                        if (item instanceof Host && !this.exposePasswordPropertiesOnHosts) continue block11;
                        this.setPasswordProperty(objectName, propertyName, this.maskPasswords ? "********" : propertyValue.toString());
                        continue block11;
                    }
                    this.setStringProperty(objectName, propertyName, propertyValue.toString());
                    continue block11;
                }
                case LIST_OF_STRING: {
                    if (propertyValue == null) {
                        this.setEmptyCollectionProperty(objectName, propertyName);
                        continue block11;
                    }
                    if (!(propertyValue instanceof List)) {
                        throw new IllegalStateException("Property " + pd + " is not a List but a " + propertyValue.getClass().getName());
                    }
                    this.setCollectionOfStringsProperty(objectName, propertyName, (List)propertyValue);
                    continue block11;
                }
                case SET_OF_STRING: {
                    if (propertyValue == null) {
                        this.setEmptyCollectionProperty(objectName, propertyName);
                        continue block11;
                    }
                    if (!(propertyValue instanceof Set)) {
                        throw new IllegalStateException("Property " + pd + " is not a Set but a " + propertyValue.getClass().getName());
                    }
                    this.setCollectionOfStringsProperty(objectName, propertyName, (Set)propertyValue);
                    continue block11;
                }
                case CI: {
                    if (d.isAssignableTo(Type.valueOf(Deployed.class)) && pd.getName().equals("deployable")) {
                        this.setNullProperty(objectName, propertyName);
                        continue block11;
                    }
                    if (propertyValue == null) {
                        this.setNullProperty(objectName, propertyName);
                        continue block11;
                    }
                    if (!(propertyValue instanceof ConfigurationItem)) {
                        throw new IllegalStateException("Property " + pd + " is not a ConfigurationItem but a " + propertyValue.getClass().getName());
                    }
                    this.setCiReferenceProperty(objectName, propertyName, (ConfigurationItem)propertyValue);
                    continue block11;
                }
                case LIST_OF_CI: {
                    if (propertyValue == null) {
                        this.setEmptyCollectionProperty(objectName, propertyName);
                        continue block11;
                    }
                    if (!(propertyValue instanceof List)) {
                        throw new IllegalStateException("Property " + pd + " is not a List but a " + propertyValue.getClass().getName());
                    }
                    this.setCollectionOfCiReferencesProperty(objectName, propertyName, (List)propertyValue);
                    continue block11;
                }
                case SET_OF_CI: {
                    if (propertyValue == null) {
                        this.setEmptyCollectionProperty(objectName, propertyName);
                        continue block11;
                    }
                    if (!(propertyValue instanceof Set)) {
                        throw new IllegalStateException("Property " + pd + " is not a Set but a " + propertyValue.getClass().getName());
                    }
                    this.setCollectionOfCiReferencesProperty(objectName, propertyName, (Set)propertyValue);
                    continue block11;
                }
                case MAP_STRING_STRING: {
                    if (propertyValue == null) {
                        this.setEmptyMapProperty(objectName, propertyName);
                        continue block11;
                    }
                    if (!(propertyValue instanceof Map)) {
                        throw new IllegalStateException("Property " + pd + " is not a Map but a " + propertyValue.getClass().getName());
                    }
                    this.setMapOfStringToStringReferencesProperty(objectName, propertyName, (Map)propertyValue);
                    continue block11;
                }
            }
            throw new IllegalStateException("Should not end up here!");
        }
    }

    private void appendDerivedPropertiesToConfigurationItemVar(String varName, ConfigurationItem item) {
        Set methodsAnnotatedWith = Scannit.getInstance().getMethodsAnnotatedWith(this.annotationClass);
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)item.getType());
        for (Method method : methodsAnnotatedWith) {
            if (!descriptor.isAssignableTo(method.getDeclaringClass())) continue;
            try {
                this.convertProperty(varName, this.getDerivedPropertyName(method), method.invoke((Object)item, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Method " + method.getName() + " in " + method.getDeclaringClass() + " cannot be accessed.", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Method " + method.getName() + " in " + method.getDeclaringClass() + " cannot be invoked.", e);
            }
        }
    }

    private void convertProperty(String objectName, String propertyName, Object propertyValue) {
        if (propertyValue == null) {
            this.setNullProperty(objectName, propertyName);
        } else if (propertyValue instanceof Boolean) {
            this.setBooleanProperty(objectName, propertyName, (Boolean)propertyValue);
        } else if (propertyValue instanceof Integer) {
            this.setIntegerProperty(objectName, propertyName, (Integer)propertyValue);
        } else if (propertyValue instanceof Long) {
            this.setIntegerProperty(objectName, propertyName, (int)((Long)propertyValue).longValue());
        } else if (propertyValue instanceof ConfigurationItem) {
            this.setCiReferenceProperty(objectName, propertyName, (ConfigurationItem)propertyValue);
        } else if (propertyValue instanceof Collection) {
            this.setCollectionOfStringsProperty(objectName, propertyName, (Collection)propertyValue);
        } else {
            this.setStringProperty(objectName, propertyName, propertyValue.toString());
        }
    }

    private void appendArtifactPropertiesToConfigurationItemVar(String varName, ConfigurationItem item) {
        if (item instanceof Artifact) {
            if (!this.uploadArtifactData) {
                logger.debug("Setting file property of [{}] to null because automatic uploading of artifact data is explicitly turned off", (Object)varName);
                this.setNullProperty(varName, FILE_PROPERTY_NAME);
                return;
            }
            if (!this.vars.containsKey(varName)) {
                logger.debug("Setting file property of [{}] to null because it is an indirectly referenced object", (Object)varName);
                this.setNullProperty(varName, FILE_PROPERTY_NAME);
                return;
            }
            if (this.executionContext != null && this.vars.containsKey(varName + STAGED_FILE_VARIABLE_NAME_PREFIX)) {
                StagedFile o = (StagedFile)this.vars.get(varName + STAGED_FILE_VARIABLE_NAME_PREFIX);
                this.setStringProperty(varName, FILE_PROPERTY_NAME, o.get(this.connection, this.executionContext).getPath());
                return;
            }
            Artifact a = (Artifact)item;
            if (!ArtifactFileUtils.canBeResolved((Artifact)a)) {
                logger.debug("Setting file property of [{}] to null because artifact cannot be resolved.", (Object)varName);
                this.setNullProperty(varName, FILE_PROPERTY_NAME);
                return;
            }
            logger.debug("Creating temporary file for variable [{}]", (Object)varName);
            OverthereFile uploadedFileArtifact = this.connection.getTempFile(a.getFile().getName());
            logger.debug("Uploading artifact for variable [{}] to [{}]", (Object)varName, (Object)uploadedFileArtifact.getPath());
            a.getFile().copyTo(uploadedFileArtifact);
            logger.debug("Uploaded artifact for variable [{}] to [{}]", (Object)varName, (Object)uploadedFileArtifact.getPath());
            this.setStringProperty(varName, FILE_PROPERTY_NAME, uploadedFileArtifact.getPath());
        }
    }

    protected String getConfigurationItemVariableName(ConfigurationItem item) {
        if (this.alreadyConvertedCis.containsKey(item)) {
            return this.alreadyConvertedCis.get(item);
        }
        String pvName = this.generateUniqueVariableName();
        this.alreadyConvertedCis.put(item, pvName);
        this.appendConfigurationItemVar(pvName, item);
        return pvName;
    }

    protected String generateUniqueVariableName() {
        return GENERATED_VARIABLE_PREFIX + this.nextVarNumber++;
    }

    protected void add(String line) {
        this.lines.add(line);
    }

    protected abstract void setNullVariable(String var1);

    protected abstract void setBooleanVariable(String var1, boolean var2);

    protected abstract void setIntegerVariable(String var1, int var2);

    protected abstract void setLongVariable(String var1, long var2);

    protected abstract void setStringVariable(String var1, String var2);

    protected abstract void setCollectionOfStringsVariable(String var1, Collection<?> var2);

    protected abstract void startCreateObject(String var1);

    protected abstract void endCreateObject(String var1);

    protected abstract void setNullProperty(String var1, String var2);

    protected abstract void setEmptyCollectionProperty(String var1, String var2);

    protected abstract void setEmptyMapProperty(String var1, String var2);

    protected abstract void setBooleanProperty(String var1, String var2, boolean var3);

    protected abstract void setIntegerProperty(String var1, String var2, int var3);

    protected abstract void setStringProperty(String var1, String var2, String var3);

    protected abstract void setPasswordProperty(String var1, String var2, String var3);

    protected abstract void setCollectionOfStringsProperty(String var1, String var2, Collection<?> var3);

    protected abstract void setCiReferenceProperty(String var1, String var2, ConfigurationItem var3);

    protected abstract void setCollectionOfCiReferencesProperty(String var1, String var2, Collection<ConfigurationItem> var3);

    protected abstract void setMapOfStringToStringReferencesProperty(String var1, String var2, Map<String, String> var3);

    protected abstract void createObjectAndSetObjectProperty(String var1, String var2);

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }
}

