/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.overthere.upgrade;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.JcrUpgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeToRemotingPlugin394
extends JcrUpgrade {
    private static Logger logger = LoggerFactory.getLogger(UpgradeToRemotingPlugin394.class);

    public Version upgradeVersion() {
        return Version.valueOf((String)"remoting-plugin", (String)"3.9.4");
    }

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        try {
            this.convertCifsConnectionTypes(repository);
            return true;
        }
        catch (RepositoryException exc) {
            throw new UpgradeException("Cannot upgrade repository to format for " + this.upgradeVersion(), (Exception)((Object)exc));
        }
    }

    private void convertCifsConnectionTypes(RawRepository repository) throws RepositoryException {
        for (Type t : this.getAssignmentCompatibleTypes("overthere.CifsHost")) {
            List websiteSpecs = repository.findNodesByType(t);
            for (Node websiteSpec : websiteSpecs) {
                this.convertCifsConnectionType(repository, websiteSpec);
            }
        }
    }

    private List<Type> getAssignmentCompatibleTypes(String typeName) {
        Type t = Type.valueOf((String)typeName);
        ArrayList types = Lists.newArrayList((Iterable)DescriptorRegistry.getSubtypes((Type)t));
        types.add(t);
        return types;
    }

    private void convertCifsConnectionType(RawRepository repository, Node overthereCifsHost) throws RepositoryException {
        if (overthereCifsHost.hasProperty("connectionType")) {
            String updatedConnectionType = null;
            Boolean updatedWinrmEnableHttps = null;
            String ct = overthereCifsHost.getProperty("connectionType").getString();
            if (ct.equals("WINRM")) {
                updatedConnectionType = "WINRM_INTERNAL";
            } else if (ct.equals("WINRM_HTTP")) {
                updatedConnectionType = "WINRM_INTERNAL";
                updatedWinrmEnableHttps = false;
            } else if (ct.equals("WINRM_HTTPS")) {
                updatedConnectionType = "WINRM_INTERNAL";
                updatedWinrmEnableHttps = true;
            } else if (ct.equals("WINRS")) {
                updatedConnectionType = "WINRM_NATIVE";
            }
            if (updatedConnectionType != null) {
                logger.info("Converting property connectionType on CI [{}] from {} to {}", new Object[]{overthereCifsHost.getPath().substring(1), ct, updatedConnectionType});
                overthereCifsHost.setProperty("connectionType", updatedConnectionType);
            }
            if (updatedWinrmEnableHttps != null) {
                logger.info("Setting property winrmEnableHttps on CI [{}] to {}", (Object)overthereCifsHost.getPath().substring(1), (Object)updatedWinrmEnableHttps);
                overthereCifsHost.setProperty("winrmEnableHttps", updatedWinrmEnableHttps.booleanValue());
            }
        }
    }
}

