/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.remoting.preview;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.remoting.preview.DevNull;
import com.xebialabs.deployit.plugin.remoting.preview.PreviewOverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.spi.BaseOverthereFile;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class PreviewOverthereFile
extends BaseOverthereFile<PreviewOverthereConnection>
implements OverthereFile {
    private PreviewOverthereConnection connection;
    private String path;

    PreviewOverthereFile(PreviewOverthereConnection connection, String path) {
        this.connection = connection;
        this.path = path;
    }

    public PreviewOverthereConnection getConnection() {
        return this.connection;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        String fileSep = this.connection.getHostOperatingSystem().getFileSeparator();
        int lastFileSepPos = this.path.lastIndexOf(fileSep);
        if (lastFileSepPos < 0) {
            return this.path;
        }
        return this.path.substring(lastFileSepPos + 1);
    }

    public OverthereFile getParentFile() {
        String fileSep = this.connection.getHostOperatingSystem().getFileSeparator();
        int lastFileSepPos = this.path.lastIndexOf(fileSep);
        if (lastFileSepPos < 0 || this.path.equals(fileSep)) {
            return null;
        }
        if (lastFileSepPos == 0) {
            return this.connection.getFile(fileSep);
        }
        return this.connection.getFile(this.path.substring(0, lastFileSepPos));
    }

    public OverthereFile getFile(String child) {
        String fileSep = this.connection.getHostOperatingSystem().getFileSeparator();
        return new PreviewOverthereFile(this.connection, this.path + fileSep + child);
    }

    public boolean exists() {
        return false;
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return false;
    }

    public boolean canExecute() {
        return false;
    }

    public boolean isFile() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public long lastModified() {
        return 0L;
    }

    public long length() {
        return 0L;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(new byte[0]);
    }

    public OutputStream getOutputStream() {
        return new DevNull();
    }

    public void setExecutable(boolean executable) {
    }

    public void delete() {
    }

    public void deleteRecursively() {
    }

    public List<OverthereFile> listFiles() {
        return Lists.newArrayList();
    }

    public void mkdir() {
    }

    public void mkdirs() {
    }

    public void renameTo(OverthereFile dest) {
    }

    public String toString() {
        return "preview:" + this.path;
    }

    protected void shortCircuitCopyFrom(OverthereFile source) {
    }

    protected void copyFrom(OverthereFile source) {
    }
}

