/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.overthere;

import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.cifs.CifsConnectionType;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="cifsPasswordCheck")
@Target(value={ElementType.TYPE})
public @interface CifsPasswordValidation {

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<Host> {
        public void validate(Host value, ValidationContext context) {
            if (value.getProperty("protocol").equals("cifs")) {
                this.checkCifsHostPassword(value, context);
            }
        }

        private void checkCifsHostPassword(Host value, ValidationContext context) {
            CifsConnectionType connectionType = (CifsConnectionType)value.getProperty("connectionType");
            String password = (String)value.getProperty("password");
            switch (connectionType) {
                case WINRM_NATIVE: {
                    if (password.indexOf(39) == -1 && password.indexOf(34) == -1) break;
                    context.error("CIFS/%s host [%s] cannot have a password with a single quote (') or a double quote (\").", new Object[]{connectionType, value.getId()});
                    break;
                }
            }
        }
    }
}

