package com.xebialabs.deployit.plugin.overthere;


import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.overthere.cifs.CifsConnectionType;

@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = CifsPasswordValidation.Validator.class, type = "cifsPasswordCheck")
@Target(ElementType.TYPE)
public @interface CifsPasswordValidation {

    public static class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<Host> {

        @Override
        public void validate(Host value, ValidationContext context) {
            if (value.getProperty("protocol").equals("cifs")) {
                checkCifsHostPassword(value, context);
            }
        }

        private void checkCifsHostPassword(Host value, ValidationContext context) {
            CifsConnectionType connectionType = value.getProperty("connectionType");
            String password = value.getProperty("password");
            switch (connectionType) {
                case WINRM_NATIVE:
                    if (password.indexOf('\'') != -1 || password.indexOf('\"') != -1) {
                        context.error("CIFS/%s host [%s] cannot have a password with a single quote (\') or a double quote (\").", connectionType, value.getId());
                    }
                    break;
                case TELNET:
                case WINRM_INTERNAL:
                    // no-op
                    break;
            }
        }

    }

}
