/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.overthere;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.flow.StagingTarget;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.overthere.step.CheckCommandExecutionStep;
import com.xebialabs.deployit.plugin.overthere.step.CheckFileTransferStep;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(root=Metadata.ConfigurationItemRoot.INFRASTRUCTURE, virtual=true, description="Machine that runs middleware, on which scripts can be executed, etc.")
public class Host
extends BaseContainer
implements HostContainer,
StagingTarget {
    @Property(description="Protocol to use when connecting to this host", hidden=true)
    private String protocol;
    @Property(label="Operating system", description="Operating system the host runs")
    private OperatingSystemFamily os;
    @Property(category="Advanced", description="Directory into which temporary files are stored. Will be cleaned up when the connection is closed.", required=false)
    private String temporaryDirectoryPath;
    @Property(category="Advanced", description="Directory into which staged files are stored. Will be cleaned up when the task is finished.", required=false)
    private String stagingDirectoryPath;
    private static Logger logger = LoggerFactory.getLogger(Host.class);

    public OverthereConnection getConnection() {
        logger.debug("Using connection protocol {}", (Object)this.protocol);
        return Overthere.getConnection((String)this.protocol, (ConnectionOptions)this.getConnectionOptions());
    }

    @ControlTask(label="Check connection", description="Checks whether XL Deploy can transfer files to and execute commands on this host.")
    public List<Step> checkConnection() {
        return Lists.newArrayList((Object[])new Step[]{new CheckFileTransferStep(this), new CheckCommandExecutionStep(this)});
    }

    @Override
    public Host getHost() {
        return this;
    }

    public OperatingSystemFamily getOs() {
        return this.os;
    }

    public void setOs(OperatingSystemFamily os) {
        this.os = os;
    }

    public String getTemporaryDirectoryPath() {
        return this.temporaryDirectoryPath;
    }

    public void setTemporaryDirectoryPath(String temporaryDirectoryPath) {
        this.temporaryDirectoryPath = temporaryDirectoryPath;
    }

    public String getStagingDirectoryPath() {
        return this.stagingDirectoryPath;
    }

    public void setStagingDirectoryPath(String stagingDirectoryPath) {
        this.stagingDirectoryPath = stagingDirectoryPath;
    }

    private ConnectionOptions getConnectionOptions() {
        return new ConnectionOptionsBuilder().getConnectionOptions(this);
    }

    public static class ConnectionOptionsBuilder {
        private List<String> jumpStationsSeen = Lists.newArrayList();
        private List<String> winrsProxiesSeen = Lists.newArrayList();

        public ConnectionOptions getConnectionOptions(Host host) {
            ConnectionOptions options = new ConnectionOptions();
            this.copyPropertiesToConnectionOptions(options, (ConfigurationItem)host);
            if (!Strings.nullToEmpty((String)host.getTemporaryDirectoryPath()).trim().isEmpty()) {
                this.setConnectionOption(options, "tmp", host.getTemporaryDirectoryPath());
            }
            logger.debug("Created connection options: {}", (Object)options);
            return options;
        }

        protected void copyPropertiesToConnectionOptions(ConnectionOptions options, ConfigurationItem ci) {
            for (PropertyDescriptor pd : ci.getType().getDescriptor().getPropertyDescriptors()) {
                Object value = pd.get(ci);
                this.setConnectionOption(options, pd.getName(), value);
            }
        }

        private void setConnectionOption(ConnectionOptions options, String key, Object value) {
            if (key.equals("protocol") || key.equals("temporaryDirectoryPath")) {
                return;
            }
            if (value == null || Strings.isNullOrEmpty((String)value.toString())) {
                return;
            }
            if (value instanceof Integer && (Integer)value == 0) {
                logger.debug("Activating workaround for DEPLOYITPB-4775: Integer with value of 0 not passed to Overthere.");
                return;
            }
            if (key.equals("jumpstation")) {
                ConfigurationItem item = (ConfigurationItem)value;
                this.checkCircularJumpStationReference((ConfigurationItem)value);
                ConnectionOptions jumpstationOptions = new ConnectionOptions();
                this.copyPropertiesToConnectionOptions(jumpstationOptions, item);
                options.set(key, (Object)jumpstationOptions);
            } else if (key.equals("winrsProxy")) {
                ConfigurationItem item = (ConfigurationItem)value;
                this.checkCircularWinrsProxyReference((ConfigurationItem)value);
                options.set("winrsProxyProtocol", item.getProperty("protocol"));
                ConnectionOptions winrsProxyOptions = new ConnectionOptions();
                this.copyPropertiesToConnectionOptions(winrsProxyOptions, item);
                options.set("winrsProxyConnectionOptions", (Object)winrsProxyOptions);
            } else {
                options.set(key, value);
            }
        }

        private void checkCircularJumpStationReference(ConfigurationItem value) {
            if (this.jumpStationsSeen.contains(value.getId())) {
                this.jumpStationsSeen.add(value.getId());
                String loop = Joiner.on((String)" -> ").join(this.jumpStationsSeen);
                throw new IllegalStateException("Detected loop in jumpstations: " + loop);
            }
            this.jumpStationsSeen.add(value.getId());
        }

        private void checkCircularWinrsProxyReference(ConfigurationItem value) {
            if (this.winrsProxiesSeen.contains(value.getId())) {
                this.winrsProxiesSeen.add(value.getId());
                String loop = Joiner.on((String)" -> ").join(this.winrsProxiesSeen);
                throw new IllegalStateException("Detected loop in winrs proxies: " + loop);
            }
            this.winrsProxiesSeen.add(value.getId());
        }
    }
}

