/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.overthere;

import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.cifs.CifsConnectionType;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="cifsUsernameCheck")
@Target(value={ElementType.TYPE})
public @interface CifsUsernameValidation {

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<Host> {
        public void validate(Host value, ValidationContext context) {
            if (value.getProperty("protocol").equals("cifs")) {
                this.checkCifsHostUsername(value, context);
            }
        }

        private void checkCifsHostUsername(Host value, ValidationContext context) {
            CifsConnectionType connectionType = (CifsConnectionType)value.getProperty("connectionType");
            String username = (String)value.getProperty("username");
            switch (connectionType) {
                case TELNET: {
                    if (!username.contains("@")) break;
                    context.error("CIFS/Telnet host [%s] cannot have a new-style domain username (%s).", new Object[]{value.getId(), username});
                    break;
                }
                case WINRM_INTERNAL: {
                    if (!username.contains("\\")) break;
                    context.error("CIFS/%s host [%s] cannot have an old-style domain username (%s).", new Object[]{connectionType, value.getId(), username});
                    break;
                }
            }
        }
    }
}

