/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.overthere.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.overthere.DefaultExecutionOutputHandler;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Closeable;
import org.apache.commons.io.IOUtils;

public class CheckFileTransferStep
implements Step {
    private final Host host;
    private final String hostname;

    public CheckFileTransferStep(Host host) {
        this.host = host;
        this.hostname = host.hasProperty("address") ? (String)host.getProperty("address") : host.getName();
    }

    public String getDescription() {
        return "Check whether XL Deploy can transfer files to " + this.hostname;
    }

    public int getOrder() {
        return 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        DefaultExecutionOutputHandler stdoutHandler = DefaultExecutionOutputHandler.handleStdout(ctx);
        DefaultExecutionOutputHandler stderrHandler = DefaultExecutionOutputHandler.handleStderr(ctx);
        try {
            try {
                OverthereConnection connection = this.host.getConnection();
                try {
                    ctx.logOutput("Uploading file to the temporary directory...");
                    OverthereFile uploadedFile = CheckFileTransferStep.uploadFile(connection);
                    ctx.logOutput("Checking read permission of uploaded file...");
                    CheckFileTransferStep.tryCanGetFilePermissions(uploadedFile);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)connection);
                }
            }
            catch (Exception exc) {
                ctx.logError("Cannot transfer files to " + this.hostname + ". Please check the connection settings.", (Throwable)exc);
                StepExitCode stepExitCode = StepExitCode.FAIL;
                IOUtils.closeQuietly((Closeable)stdoutHandler);
                IOUtils.closeQuietly((Closeable)stderrHandler);
                return stepExitCode;
            }
            ctx.logOutput("Successfully transferred files to " + this.hostname + ".");
            StepExitCode stepExitCode = StepExitCode.SUCCESS;
            return stepExitCode;
        }
        finally {
            IOUtils.closeQuietly((Closeable)stdoutHandler);
            IOUtils.closeQuietly((Closeable)stderrHandler);
        }
    }

    private static OverthereFile uploadFile(OverthereConnection connection) {
        OverthereFile fileToUpload = connection.getTempFile("hostconnection-remote", ".txt");
        OverthereUtils.write((String)"Contents of host connection test file", (String)"UTF-8", (OverthereFile)fileToUpload);
        return fileToUpload;
    }

    private static void tryCanGetFilePermissions(OverthereFile uploadedFile) {
        if (!uploadedFile.canRead()) {
            throw new RuntimeException("Cannot check read permission for file just uploaded");
        }
    }
}

