/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.remoting.preview;

import com.xebialabs.deployit.plugin.remoting.preview.PreviewOverthereFile;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import com.xebialabs.overthere.spi.OverthereConnectionBuilder;
import com.xebialabs.overthere.spi.Protocol;

@Protocol(name="preview")
public class PreviewOverthereConnection
extends BaseOverthereConnection
implements OverthereConnectionBuilder {
    public static final String PREVIEW_PROTOCOL = "preview";

    public PreviewOverthereConnection(String protocol, ConnectionOptions options, AddressPortMapper mapper) {
        super(protocol, PreviewOverthereConnection.fixOptions(options), mapper, false);
    }

    private static ConnectionOptions fixOptions(ConnectionOptions options) {
        options = new ConnectionOptions(options);
        options.set("os", (Object)OperatingSystemFamily.getLocalHostOperatingSystemFamily());
        if (options.getOptional("tmp") == null) {
            options.set("tmp", (Object)System.getProperty("java.io.tmpdir"));
        }
        return options;
    }

    public OverthereConnection connect() {
        return this;
    }

    protected void doClose() {
    }

    public OverthereFile getFile(String hostPath) {
        return new PreviewOverthereFile(this, hostPath);
    }

    public OverthereFile getFile(OverthereFile parent, String child) {
        return parent.getFile(child);
    }

    protected OverthereFile getFileForTempFile(OverthereFile parent, String name) {
        return parent.getFile(name);
    }

    public String toString() {
        return "preview:";
    }

    public static OverthereConnection getPreviewConnection() {
        return Overthere.getConnection((String)PREVIEW_PROTOCOL, (ConnectionOptions)new ConnectionOptions());
    }
}

