/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.overthere.step;

import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.overthere.AutoFlushingExecutionContextOverthereProcessOutputHandler;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Closeable;

public class CheckConnectionStep
implements Step<DeploymentExecutionContext> {
    private Host host;

    public CheckConnectionStep(Host host) {
        this.host = host;
    }

    public String getDescription() {
        return "Check connection to " + this.host.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result execute(DeploymentExecutionContext ctx) throws Exception {
        AutoFlushingExecutionContextOverthereProcessOutputHandler handler = new AutoFlushingExecutionContextOverthereProcessOutputHandler((ExecutionContext)ctx);
        try {
            String hostName = this.host.getName();
            if (this.host.hasProperty("address")) {
                hostName = (String)this.host.getProperty("address");
            }
            try {
                OverthereConnection connection = this.host.getConnection();
                try {
                    ctx.logOutput("Attempting to list the contents of the temporary directory");
                    ctx.logOutput("----------------------------------------------------------");
                    this.echoTmpDirContents(connection, handler);
                    ctx.logOutput("----------------------------------------------------------");
                    ctx.logOutput("Uploading file to the temporary directory");
                    ctx.logOutput("----------------------------------------------------------");
                    OverthereFile fileToUpload = this.uploadFile(connection);
                    ctx.logOutput("-----------------------------------------");
                    ctx.logOutput("Checking read permission of uploaded file");
                    ctx.logOutput("-----------------------------------------");
                    this.tryCanGetFilePermissions(connection, fileToUpload);
                    ctx.logOutput("-----------------------------------------");
                }
                finally {
                    Closeables.closeQuietly((Closeable)connection);
                }
            }
            catch (Exception exc) {
                handler.handleErrorLine(String.format("Connection test to host " + hostName + " failed. Please check address, username and password. Exception message is: %s%n%s", exc, Throwables.getStackTraceAsString((Throwable)exc)));
                Step.Result result = Step.Result.Fail;
                handler.close();
                return result;
            }
            handler.handleOutputLine("Connection test to host " + hostName + " succeeded");
            Step.Result result = Step.Result.Success;
            return result;
        }
        finally {
            handler.close();
        }
    }

    private void echoTmpDirContents(OverthereConnection connection, OverthereProcessOutputHandler handler) {
        String dircmd = connection.getHostOperatingSystem() == OperatingSystemFamily.UNIX ? "ls" : "dir";
        CmdLine cmdLine = new CmdLine();
        cmdLine.addArgument(dircmd);
        String tempDir = this.host.getTemporaryDirectoryPath();
        if (tempDir == null) {
            tempDir = connection.getHostOperatingSystem().getDefaultTemporaryDirectoryPath();
        }
        cmdLine.addArgument(tempDir);
        connection.execute(handler, cmdLine);
    }

    private OverthereFile uploadFile(OverthereConnection connection) {
        OverthereFile fileToUpload = connection.getTempFile("hostconnection-remote", ".txt");
        OverthereUtils.write((String)"Contents of host connection test file", (String)"UTF-8", (OverthereFile)fileToUpload);
        return fileToUpload;
    }

    private void tryCanGetFilePermissions(OverthereConnection connection, OverthereFile uploadedFile) {
        OverthereFile filesJustUploadedNotAsATempFile = connection.getFile(uploadedFile.getPath());
        if (!filesJustUploadedNotAsATempFile.canRead()) {
            throw new RuntimeException("Cannot check read permission for file just uploaded");
        }
    }
}

