/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.remoting.scripts;

import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.utils.TFileUtils;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.OverthereUtils;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;

public class ScriptUtils {
    public static final String MDC_KEY_SCRIPT_PATH = "scriptPath";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadScript(String string) {
        String string2;
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        if (uRL == null) {
            throw new IllegalArgumentException("Cannot load script from " + string + ": script does not exist on classpath");
        }
        TFile tFile = null;
        try {
            tFile = new TFile(new URI(uRL.toString()));
            string2 = ScriptUtils.loadScriptFromFile(tFile);
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                throw new RuntimeIOException("Cannot load script from " + string, (Throwable)uRISyntaxException);
                catch (IOException iOException) {
                    throw new RuntimeIOException("Cannot load script from " + string, (Throwable)iOException);
                }
            }
            catch (Throwable throwable) {
                TFileUtils.umountQuietly(tFile);
                throw throwable;
            }
        }
        TFileUtils.umountQuietly((TFile)tFile);
        return string2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadScriptDir(String string) {
        String string2;
        if (string == null) {
            return "";
        }
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        if (uRL == null) {
            throw new IllegalArgumentException("Cannot load scripts from " + string + ": script directory does not exist on classpath");
        }
        TFile tFile = null;
        try {
            tFile = new TFile(new URI(uRL.toString()));
            TFile[] tFileArray = tFile.listFiles();
            if (tFileArray == null) {
                throw new IllegalArgumentException("Cannot load scripts from " + tFile + ": not a directory");
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (TFile tFile2 : tFileArray) {
                stringBuilder.append(ScriptUtils.loadScriptFromFile(tFile2));
            }
            string2 = stringBuilder.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                throw new RuntimeIOException("Cannot read scripts from " + string, (Throwable)uRISyntaxException);
                catch (IOException iOException) {
                    throw new RuntimeIOException("Cannot read scripts from " + string, (Throwable)iOException);
                }
            }
            catch (Throwable throwable) {
                TFileUtils.umountQuietly(tFile);
                throw throwable;
            }
        }
        TFileUtils.umountQuietly((TFile)tFile);
        return string2;
    }

    public static String loadScriptFromFile(TFile tFile) throws FileNotFoundException {
        TFileReader tFileReader = new TFileReader(tFile);
        try {
            String string = "# " + tFile + "\n" + CharStreams.toString((Readable)tFileReader);
            return string;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot load script from " + tFile, iOException);
        }
        finally {
            Closeables.closeQuietly((Closeable)tFileReader);
        }
    }

    public static void dumpScript(String string, String string2, Logger logger) {
        if (logger.isTraceEnabled()) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            logger.trace(":::: " + simpleDateFormat.format(new Date()) + " :::: " + string + " ::::");
            String[] stringArray = string2.split("\r?\n");
            for (int i = 0; i < stringArray.length; ++i) {
                logger.trace(i + 1 + " : " + stringArray[i]);
            }
        }
    }

    public static OverthereFile uploadScript(OverthereConnection overthereConnection, String string, String string2) {
        OverthereFile overthereFile = overthereConnection.getTempFile(OverthereUtils.getName((String)string));
        OverthereUtils.write((String)string2, (String)"UTF-8", (OverthereFile)overthereFile);
        return overthereFile;
    }
}

