/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.overthere;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.overthere.step.CheckConnectionStep;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(root=Metadata.ConfigurationItemRoot.INFRASTRUCTURE, virtual=true, description="A machine that runs middleware, on which scripts can be executed, etc.")
public class Host
extends BaseContainer
implements HostContainer {
    @Property(description="Protocol to use when connecting to this host", hidden=true)
    private String protocol;
    @Property(description="Operating system")
    private OperatingSystemFamily os;
    @Property(description="Directory into which temporary files are stored. Will be cleaned up when the connection is closed.", required=false)
    private String temporaryDirectoryPath;
    private static Logger logger = LoggerFactory.getLogger(Host.class);

    public OverthereConnection getConnection() {
        logger.debug("Using connection protocol {}", (Object)this.protocol);
        return Overthere.getConnection((String)this.protocol, (ConnectionOptions)this.getConnectionOptions());
    }

    private ConnectionOptions getConnectionOptions() {
        ConnectionOptions connectionOptions = new ConnectionOptions();
        this.copyPropertiesToConnectionOptions(connectionOptions, (ConfigurationItem)this);
        if (!Strings.nullToEmpty((String)this.getTemporaryDirectoryPath()).trim().isEmpty()) {
            this.setConnectionOption(connectionOptions, "tmp", this.getTemporaryDirectoryPath());
            logger.debug("Setting connection option {}: {}", (Object)"tmp", (Object)this.getTemporaryDirectoryPath());
        }
        return connectionOptions;
    }

    protected void copyPropertiesToConnectionOptions(ConnectionOptions connectionOptions, ConfigurationItem configurationItem) {
        for (PropertyDescriptor propertyDescriptor : configurationItem.getType().getDescriptor().getPropertyDescriptors()) {
            Object object = propertyDescriptor.get(configurationItem);
            this.setConnectionOption(connectionOptions, propertyDescriptor.getName(), object);
            logger.debug("Setting connection option {}: {}", (Object)propertyDescriptor.getName(), propertyDescriptor.isPassword() ? "********" : object);
        }
    }

    private void setConnectionOption(ConnectionOptions connectionOptions, String string, Object object) {
        if (string.equals("protocol") || string.equals("temporaryDirectoryPath")) {
            return;
        }
        if (object == null || Strings.isNullOrEmpty((String)object.toString())) {
            return;
        }
        if (string.equals("jumpstation")) {
            ConnectionOptions connectionOptions2 = new ConnectionOptions();
            this.copyPropertiesToConnectionOptions(connectionOptions2, (ConfigurationItem)object);
            connectionOptions.set(string, (Object)connectionOptions2);
        } else {
            connectionOptions.set(string, object);
        }
    }

    @ControlTask(description="Check connection")
    public List<Step<?>> checkConnection() {
        return Lists.newArrayList((Object[])new Step[]{new CheckConnectionStep(this)});
    }

    @Override
    public Host getHost() {
        return this;
    }

    public OperatingSystemFamily getOs() {
        return this.os;
    }

    public void setOs(OperatingSystemFamily operatingSystemFamily) {
        this.os = operatingSystemFamily;
    }

    public String getTemporaryDirectoryPath() {
        return this.temporaryDirectoryPath;
    }

    public void setTemporaryDirectoryPath(String string) {
        this.temporaryDirectoryPath = string;
    }
}

