/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.remoting.inspection;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.ITask;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectionProtocolContext
implements ExecutionContext {
    private final ExecutionContext context;
    private static final String defaultEncoding = "UTF-8";
    public static final String DISCOVERED_ITEM_PRELUDE = "DISCOVERED-ITEM:";
    public static final String INSPECTED_PROPERTY_PRELUDE = "INSPECTED-PROPERTY:";
    public static final String INSPECTED_ITEM_PRELUDE = "INSPECTED-ITEM";
    protected ConfigurationItem currentInspectedItem;
    private volatile boolean inspectionFailed;
    private static Logger logger = LoggerFactory.getLogger(InspectionProtocolContext.class);

    public InspectionProtocolContext(ConfigurationItem inspectedItem, ExecutionContext context) {
        this.context = context;
        this.currentInspectedItem = inspectedItem;
    }

    public boolean isInspectionFailed() {
        return this.inspectionFailed;
    }

    public void logOutput(String output) {
        try {
            logger.trace("Handling inspection protocol line {}", (Object)output);
            if (this.handleOutputLine(output, this.context)) {
                logger.trace("Handled inspection protocol line {}", (Object)output);
            } else {
                this.context.logOutput(output);
            }
        }
        catch (RuntimeException exc) {
            this.context.logError("Inspection failed", (Throwable)exc);
            this.inspectionFailed = true;
        }
    }

    protected boolean handleOutputLine(String line, ExecutionContext ctx) {
        String[] lineSegments = line.split(":");
        try {
            if (line.startsWith(DISCOVERED_ITEM_PRELUDE)) {
                Preconditions.checkArgument((lineSegments.length == 3 ? 1 : 0) != 0, (String)"%s is incorrectly encoded. Expected format '%sid:type' but was %s", (Object)DISCOVERED_ITEM_PRELUDE, (Object)DISCOVERED_ITEM_PRELUDE, (Object)line);
                String id = URLDecoder.decode(lineSegments[1], defaultEncoding);
                String typeName = lineSegments[2];
                return this.handleDiscoveredItem(id, typeName, ctx);
            }
            if (line.startsWith(INSPECTED_PROPERTY_PRELUDE)) {
                Preconditions.checkArgument((lineSegments.length > 2 ? 1 : 0) != 0, (String)"%s is incorrectly encoded. Expected format '%sid:name:value1:value2:..' but was %s", (Object)INSPECTED_PROPERTY_PRELUDE, (Object)INSPECTED_PROPERTY_PRELUDE, (Object)line);
                String id = URLDecoder.decode(lineSegments[1], defaultEncoding);
                String name = URLDecoder.decode(lineSegments[2], defaultEncoding);
                String[] values = new String[lineSegments.length - 3];
                System.arraycopy(lineSegments, 3, values, 0, values.length);
                for (int i = 0; i < values.length; ++i) {
                    values[i] = URLDecoder.decode(values[i], defaultEncoding);
                }
                return this.handleInspectedProperty(id, name, values, ctx);
            }
            if (line.startsWith(INSPECTED_ITEM_PRELUDE)) {
                Preconditions.checkArgument((lineSegments.length == 2 ? 1 : 0) != 0, (String)"%s is incorrectly encoded. Expected format '%sid' but was %s", (Object)INSPECTED_ITEM_PRELUDE, (Object)line);
                String id = URLDecoder.decode(lineSegments[1], defaultEncoding);
                return InspectionProtocolContext.handleInspectedItem(id, ctx);
            }
        }
        catch (UnsupportedEncodingException encodingException) {
            logger.debug("Unsupported encoding exception was encountered while parsing inspected and / or discovered items");
            return false;
        }
        return false;
    }

    private boolean handleDiscoveredItem(String id, String typeName, ExecutionContext ctx) throws UnsupportedEncodingException {
        Type type = Type.valueOf((String)URLDecoder.decode(typeName, defaultEncoding));
        if (!DescriptorRegistry.exists((Type)type)) {
            ctx.logError("Discovered item " + id + " of unknown type " + type);
            return false;
        }
        Descriptor d = DescriptorRegistry.getDescriptor((Type)type);
        ConfigurationItem discoveredItem = d.newInstance(id);
        this.setReferenceFromChildToParent(discoveredItem, d, ctx);
        ctx.getInspectionContext().discovered(discoveredItem);
        logger.debug("Discovered item {} with type {}", (Object)id, (Object)type);
        return true;
    }

    protected void setReferenceFromChildToParent(ConfigurationItem discoveredItem, Descriptor d, ExecutionContext ctx) {
        for (PropertyDescriptor pd : d.getPropertyDescriptors()) {
            boolean isReferenceToParent = pd.getKind() == PropertyKind.CI && pd.isAsContainment();
            if (!isReferenceToParent) continue;
            ConfigurationItem parent = this.getParent(discoveredItem.getId(), pd, ctx);
            pd.set(discoveredItem, (Object)parent);
            for (PropertyDescriptor ppd : parent.getType().getDescriptor().getPropertyDescriptors()) {
                boolean isReferenceToChild = (ppd.getKind() == PropertyKind.SET_OF_CI || ppd.getKind() == PropertyKind.LIST_OF_CI) && ppd.isAsContainment() && d.isAssignableTo(ppd.getReferencedType());
                if (!isReferenceToChild) continue;
                Collection refs = (Collection)ppd.get(parent);
                refs.add(discoveredItem);
                ppd.set(parent, (Object)refs);
            }
        }
    }

    private ConfigurationItem getParent(String id, PropertyDescriptor pd, ExecutionContext ctx) {
        ConfigurationItem parent;
        String parentId = InspectionProtocolContext.getParentId(id);
        if (parentId.equals(this.currentInspectedItem.getId())) {
            parent = this.currentInspectedItem;
        } else {
            parent = (ConfigurationItem)ctx.getInspectionContext().getInspected().get(parentId);
            if (parent == null) {
                parent = (ConfigurationItem)ctx.getInspectionContext().getDiscovered().get(parentId);
                Preconditions.checkArgument((parent != null ? 1 : 0) != 0, (String)"Cannot resolve parent reference from item [%s] for property [%s]", (Object)id, (Object)pd);
            }
        }
        return parent;
    }

    private static String getParentId(String id) {
        int indexOfLastSlash = id.lastIndexOf(47);
        Preconditions.checkArgument((indexOfLastSlash != -1 ? 1 : 0) != 0, (String)"[%s] has no parent", (Object)id);
        return id.substring(0, indexOfLastSlash);
    }

    private boolean handleInspectedProperty(String id, String name, String[] values, ExecutionContext ctx) {
        ConfigurationItem inspectedItem;
        logger.trace("Handling inspection for property {} on ci {} with values {}", new Object[]{name, id, Arrays.toString(values)});
        if (values.length == 0) {
            logger.debug("No inspected value specified for property {} on ci {}. Ignoring.", (Object)name, (Object)id);
            return false;
        }
        if (id.equals("this")) {
            inspectedItem = this.currentInspectedItem;
        } else {
            inspectedItem = (ConfigurationItem)ctx.getInspectionContext().getDiscovered().get(id);
            if (inspectedItem == null) {
                ctx.logError(String.format("Cannot inspect property %s on unknown item %s", name, id));
                return false;
            }
        }
        Descriptor d = inspectedItem.getType().getDescriptor();
        PropertyDescriptor pd = d.getPropertyDescriptor(name);
        if (pd == null) {
            ctx.logOutput("Inspected unknown property " + name + ". Ignoring...");
            return false;
        }
        PropertyKind kind = pd.getKind();
        if (pd.isHidden()) {
            ctx.logOutput("Inspected property " + name + " is hidden. Ignoring...");
            return false;
        }
        switch (kind) {
            case SET_OF_CI: 
            case LIST_OF_CI: {
                Collection refs = (Collection)Preconditions.checkNotNull((Object)((Collection)pd.get(inspectedItem)));
                refs.add(InspectionProtocolContext.resolveCiReference(values[0], pd, ctx));
                break;
            }
            case SET_OF_STRING: 
            case LIST_OF_STRING: {
                Collection stringProperties = (Collection)Preconditions.checkNotNull((Object)((Collection)pd.get(inspectedItem)));
                stringProperties.add(values[0]);
                break;
            }
            case MAP_STRING_STRING: {
                Map mapProperties = (Map)Preconditions.checkNotNull((Object)((Map)pd.get(inspectedItem)));
                if (values.length == 1) {
                    mapProperties.put(values[0], "");
                    break;
                }
                mapProperties.put(values[0], values[1]);
                break;
            }
            case CI: {
                pd.set(inspectedItem, (Object)InspectionProtocolContext.resolveCiReference(values[0], pd, ctx));
                break;
            }
            default: {
                pd.set(inspectedItem, (Object)values[0]);
            }
        }
        logger.debug("Inspected property {} on item {}", (Object)name, (Object)id);
        return true;
    }

    private static ConfigurationItem resolveCiReference(String id, PropertyDescriptor pd, ExecutionContext ctx) {
        ConfigurationItem referencedCi = (ConfigurationItem)ctx.getInspectionContext().getInspected().get(id);
        Preconditions.checkArgument((referencedCi != null ? 1 : 0) != 0, (String)"Cannot resolve CI reference to [%s] from [%s]", (Object)id, (Object)pd);
        return referencedCi;
    }

    private static boolean handleInspectedItem(String id, ExecutionContext ctx) {
        ConfigurationItem inspectedItem = (ConfigurationItem)ctx.getInspectionContext().getDiscovered().get(id);
        if (inspectedItem == null) {
            ctx.logError(String.format("Cannot mark %s as inspected because it has not been discovered yet", id));
            return false;
        }
        logger.debug("Inspected item {}", (Object)inspectedItem);
        ctx.getInspectionContext().inspected(inspectedItem);
        return true;
    }

    public void logError(String error) {
        this.context.logError(error);
    }

    public void logError(String error, Throwable t) {
        this.context.logError(error, t);
    }

    public Object getAttribute(String name) {
        return this.context.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.context.setAttribute(name, value);
    }

    public Repository getRepository() {
        return this.context.getRepository();
    }

    public InspectionContext getInspectionContext() {
        return this.context.getInspectionContext();
    }

    public ITask getTask() {
        return this.context.getTask();
    }
}

