package com.xebialabs.deployit.plugin.python;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.remoting.inspection.InspectionProtocolContext;

@SuppressWarnings("serial")
public class PythonInspectionStep extends PythonStep {

    protected ConfigurationItem itemToInspect;

    public PythonInspectionStep(ConfigurationItem inspectedItem, PythonManagingContainer container, String scriptPath, Map<String, Object> pythonVars, String description) {
        super(container, scriptPath, pythonVars, 50, description);
        this.itemToInspect = inspectedItem;
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        InspectionProtocolContext protocolContext = new InspectionProtocolContext(itemToInspect, ctx);
        StepExitCode result = doExecute(protocolContext);

        if (protocolContext.isInspectionFailed()) {
            ctx.logError("Inspection failed, check the logs");
            result = StepExitCode.FAIL;
        }

        return result;
    }
}
