import sys
import base64
from urllib import quote_plus

##
# WAS 6.1 uses Python version 2.1 which doesn't support boolean literals True and False
##
if sys.version[:3] == "2.1":
    global False
    False = 0
    global True
    True = 1

class DictionaryObject:
    def __setattr__(self, propertyName, propertyValue):
        self.__dict__[propertyName] = propertyValue

    def getExposedPropertyNames(self):
        propertiesNotToExpose = ['standardPropertiesNotToExpose', 'additionalPropertiesNotToExpose']    
        if self.__dict__.has_key('standardPropertiesNotToExpose'):
            propertiesNotToExpose.extend(striplist(self.__dict__['standardPropertiesNotToExpose'].split(',')))
        if self.__dict__.has_key('additionalPropertiesNotToExpose'):
            propertiesNotToExpose.extend(striplist(self.__dict__['additionalPropertiesNotToExpose'].split(',')))
        return [p for p in self._properties if p not in propertiesNotToExpose]

    def getExposedProperties(self, encodeValuesAsString = False):
        propertiesNotToExpose = ['standardPropertiesNotToExpose', 'additionalPropertiesNotToExpose']    
        if self.__dict__.has_key('standardPropertiesNotToExpose'):
            propertiesNotToExpose.extend(striplist(self.__dict__['standardPropertiesNotToExpose'].split(',')))
        if self.__dict__.has_key('additionalPropertiesNotToExpose'):
            propertiesNotToExpose.extend(striplist(self.__dict__['additionalPropertiesNotToExpose'].split(',')))
        n = {}
        for k in self._properties:
             if k not in propertiesNotToExpose:
                 if encodeValuesAsString and self.__dict__.has_key(k + '_as_string'):
                     n[k] = self.__dict__[k + '_as_string']
                 else:
                     n[k] = self.__dict__[k]
        return n
    
    def getNestedObjects(self):
        nestedObjects = {} 
        for propName, propValue in self.getExposedProperties().items():
            if isinstance(propValue, DictionaryObject) == True:
                nestedObjects[propName] = propValue
        return nestedObjects

def discovered(id, type):
    print "DISCOVERED-ITEM:" + quote_plus(id) + ":" + quote_plus(type)

def inspectedProperty(id, name, value):
    if isinstance(value, type([])):
        for v in value:
            print "INSPECTED-PROPERTY:" + quote_plus(id) + ":" + quote_plus(name) + ":" + quote_plus(str(v))
    elif isinstance(value, type({})):
        for k,v in value.items():
            if v is None:
                v = ""
            print "INSPECTED-PROPERTY:" + quote_plus(id) + ":" + quote_plus(name) + ":" + quote_plus(str(k)) + ":" + quote_plus(str(v))
    elif value is not None:
        print "INSPECTED-PROPERTY:" + quote_plus(id) + ":" + quote_plus(name) + ":" + quote_plus(str(value))

def inspected(name, value):
    inspectedProperty('this', name, value)

def inspectedItem(id):
    print "INSPECTED-ITEM:" + quote_plus(id)   


# Take a list of string objects and return the same list
# stripped of extra whitespace.
def striplist(l):
    return([x.strip() for x in l])
