/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.python;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.StageableStep;
import com.xebialabs.deployit.plugin.api.flow.StagedFile;
import com.xebialabs.deployit.plugin.api.flow.StagingContext;
import com.xebialabs.deployit.plugin.api.flow.StagingTarget;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.python.PythonDaemon;
import com.xebialabs.deployit.plugin.python.PythonManagedDeployed;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.python.PythonVarsConverter;
import com.xebialabs.deployit.plugin.remoting.preview.PreviewOverthereConnection;
import com.xebialabs.deployit.plugin.remoting.scripts.ScriptUtils;
import com.xebialabs.deployit.plugin.steps.CalculatedStep;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.util.OverthereUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

abstract class PythonStep
extends CalculatedStep
implements PreviewStep,
StageableStep {
    private static final String BASE_RUNTIME_PATH = "python/runtime";
    private PythonManagingContainer container;
    private String scriptPath;
    private Map<String, Object> scriptContext = new HashMap<String, Object>();
    private boolean uploadArtifactData = true;
    private Preview preview;
    private static final Logger logger = LoggerFactory.getLogger(PythonStep.class);
    private static final Logger scriptsLogger = LoggerFactory.getLogger((String)"com.xebialabs.deployit.plugin.python.scripts");

    public PythonStep(PythonManagingContainer container, String scriptPath, Map<String, Object> scriptContext, Integer order, String description) {
        super((Integer)Preconditions.checkNotNull((Object)order, (Object)"order is null"), (String)Preconditions.checkNotNull((Object)description, (Object)"description is null"));
        this.container = (PythonManagingContainer)Preconditions.checkNotNull((Object)container, (Object)"container is null");
        this.scriptPath = (String)Preconditions.checkNotNull((Object)scriptPath, (Object)"scriptPath is null");
        this.scriptContext = (Map)Preconditions.checkNotNull(scriptContext, (Object)"scriptContext is null");
    }

    public PythonStep(PythonManagingContainer container, String scriptPath, Map<String, Object> scriptContext, String description) {
        this(container, scriptPath, scriptContext, 50, description);
    }

    public void requestStaging(StagingContext ctx) {
        if (!this.uploadArtifactData) {
            return;
        }
        HashMap<String, Object> stagedFilesMap = new HashMap<String, Object>(this.getPythonVars());
        for (Map.Entry<String, Object> entry : this.scriptContext.entrySet()) {
            if (!(entry.getValue() instanceof Artifact)) continue;
            StagedFile stagedFile = ctx.stageArtifact((Artifact)entry.getValue(), (StagingTarget)this.container.getHost());
            stagedFilesMap.put(entry.getKey() + "_stagedFile", stagedFile);
        }
        this.scriptContext = stagedFilesMap;
    }

    /*
     * Loose catch block
     */
    protected StepExitCode doExecute(ExecutionContext ctx) throws Exception {
        MDC.put((String)"scriptPath", (String)this.scriptPath);
        try {
            try (OverthereConnection conn = this.container.getHost().getConnection();){
                String generatedScript = this.aggregateScript(conn, ctx, false);
                PythonStep.dumpPythonScript(OverthereUtils.getName((String)this.scriptPath), generatedScript);
                OverthereFile uploadedScriptFile = ScriptUtils.uploadScript((OverthereConnection)conn, (String)this.scriptPath, (String)generatedScript);
                int res = this.executePythonScript(ctx, conn, uploadedScriptFile);
                logger.debug("Exit code: {}", (Object)res);
                if (res == 0) {
                    StepExitCode stepExitCode = StepExitCode.SUCCESS;
                    return stepExitCode;
                }
                StepExitCode stepExitCode = StepExitCode.FAIL;
                return stepExitCode;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            MDC.remove((String)"scriptPath");
        }
    }

    public Preview getPreview() {
        if (this.preview == null) {
            try (OverthereConnection poc = PreviewOverthereConnection.getPreviewConnection();){
                String contents = this.aggregateScript(poc, null, true);
                this.preview = Preview.withSourcePathAndContents((String)this.scriptPath, (String)contents);
            }
        }
        return this.preview;
    }

    protected String aggregateScript(OverthereConnection connection, ExecutionContext ctx, boolean maskPasswords) {
        String pythonVarsPython = PythonVarsConverter.javaToPython(connection, this.scriptContext, this.uploadArtifactData, ctx, maskPasswords);
        StringBuilder b = new StringBuilder();
        if (!this.container.runWithDaemon() || !connection.canStartProcess()) {
            PythonStep.appendRuntimeScripts(this.container, b);
        }
        this.appendDeployedRuntimeScripts(b);
        b.append("# PythonVars\n");
        b.append(pythonVarsPython);
        if (!this.container.runWithDaemon() || !connection.canStartProcess()) {
            b.append("#\nconnectFromStandAloneScript()\n");
        }
        b.append(ScriptUtils.loadScript((String)this.scriptPath));
        if (!this.container.runWithDaemon() || !connection.canStartProcess()) {
            b.append("#\ndisconnectFromStandAloneScript()\n");
        }
        return b.toString();
    }

    static void appendRuntimeScripts(PythonManagingContainer c, StringBuilder b) {
        PythonStep.appendBaseRuntimeScripts(b);
        PythonStep.appendContainerRuntimeScripts(c, b);
        PythonStep.appendContainerLibraryScripts(c, b);
    }

    private static void appendBaseRuntimeScripts(StringBuilder b) {
        ScriptUtils.appendScriptDir((String)BASE_RUNTIME_PATH, (StringBuilder)b);
    }

    private static void appendContainerRuntimeScripts(PythonManagingContainer c, StringBuilder b) {
        ScriptUtils.appendScriptDir((String)c.getRuntimePath(), (StringBuilder)b);
    }

    private static void appendContainerLibraryScripts(PythonManagingContainer c, StringBuilder b) {
        if (c.hasProperty("libraryScripts")) {
            List scripts = (List)c.getProperty("libraryScripts");
            ScriptUtils.appendScripts((List)scripts, (StringBuilder)b);
        }
    }

    private void appendDeployedRuntimeScripts(StringBuilder b) {
        PythonManagedDeployed deployed = (PythonManagedDeployed)((Object)this.scriptContext.get("deployed"));
        PythonManagedDeployed pythonManagedDeployed = deployed = deployed == null ? (PythonManagedDeployed)((Object)this.scriptContext.get("prototype")) : deployed;
        if (deployed != null) {
            for (String script : deployed.getLibraryScripts()) {
                b.append(ScriptUtils.loadScript((String)script));
            }
        }
    }

    private int executePythonScript(ExecutionContext ctx, OverthereConnection conn, OverthereFile script) {
        if (this.container.runWithDaemon() && conn.canStartProcess()) {
            return this.getDaemon(ctx).executePythonScript(ctx, script);
        }
        return this.executePythonScriptDirectly(ctx, conn, script);
    }

    /*
     * Exception decompiling
     */
    protected int executePythonScriptDirectly(ExecutionContext ctx, OverthereConnection conn, OverthereFile script) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PythonDaemon getDaemon(ExecutionContext context) {
        String key = "DAEMON_" + this.container.getId();
        PythonDaemon daemon = (PythonDaemon)context.getAttribute(key);
        if (daemon == null || !daemon.isAlive()) {
            daemon = new PythonDaemon(this.container);
            context.setAttribute(key, (Object)daemon);
            daemon.start(context);
        }
        return daemon;
    }

    String getScriptPath() {
        return this.scriptPath;
    }

    Map<String, Object> getPythonVars() {
        return this.scriptContext;
    }

    public void setUploadArtifactData(boolean uploadArtifactData) {
        this.uploadArtifactData = uploadArtifactData;
    }

    public String toString() {
        return this.scriptPath;
    }

    public static void dumpPythonScript(String scriptName, String scriptContents) {
        ScriptUtils.dumpScript((String)scriptName, (String)scriptContents, (Logger)scriptsLogger);
    }
}

