/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.python;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.python.DerivedProperty;
import com.xebialabs.deployit.plugin.remoting.vars.VarsConverter;
import com.xebialabs.overthere.OverthereConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class PythonVarsConverter
extends VarsConverter {
    private static final String INDENT = "    ";
    private int objectDepth = 0;
    private int currentFunctionNumber = 0;
    private boolean shouldOpenFunction = false;
    private boolean functionOpened = false;

    public static String javaToPython(OverthereConnection connection, Map<String, Object> pythonVars) {
        return PythonVarsConverter.javaToPython(connection, pythonVars, true, null);
    }

    public static String javaToPython(OverthereConnection connection, Map<String, Object> pythonVars, boolean uploadArtifactData, ExecutionContext ctx) {
        List<String> pythonList = PythonVarsConverter.javaToPythonList(connection, pythonVars, uploadArtifactData, ctx);
        return Joiner.on((String)"\n").join(pythonList) + "\n";
    }

    static List<String> javaToPythonList(OverthereConnection connection, Map<String, Object> pythonVars, boolean uploadArtifactData, ExecutionContext ctx) {
        PythonVarsConverter converter = new PythonVarsConverter(connection, pythonVars);
        converter.setUploadArtifactData(uploadArtifactData);
        converter.setExecutionContext(ctx);
        return converter.convert();
    }

    private PythonVarsConverter(OverthereConnection connection, Map<String, Object> pythonVars) {
        super(connection, pythonVars, DerivedProperty.class);
    }

    protected void setNullVariable(String varName) {
        this.add(varName + " = None");
    }

    protected void setBooleanVariable(String varName, boolean varValue) {
        this.add(varName + " = " + (varValue ? "True" : "False"));
        this.add(varName + "_as_string = " + (varValue ? "'true'" : "'false'"));
    }

    protected void setIntegerVariable(String varName, int varValue) {
        this.add(varName + " = " + varValue);
    }

    protected void setLongVariable(String varName, long varValue) {
        this.add(varName + " = " + varValue + "L");
    }

    protected void setStringVariable(String varName, String varValue) {
        this.add(varName + " = " + PythonVarsConverter.toPythonString(varValue));
    }

    protected void setCollectionOfStringsVariable(String varName, Collection<?> varValue) {
        if (varValue.isEmpty()) {
            this.add(varName + " = []");
        } else {
            Collection encodedStrings = Collections2.transform(varValue, (Function)new Function<Object, String>(){

                public String apply(Object input) {
                    return PythonVarsConverter.toPythonString(input.toString());
                }
            });
            this.add(varName + " = [" + Joiner.on((String)", ").join((Iterable)encodedStrings) + "]");
        }
    }

    protected void startCreateObject(String varName) {
        if (this.objectDepth++ > 0) {
            this.endFunction();
        }
        this.startFunction();
        if (varName.indexOf(46) == -1) {
            this.add("    global " + varName);
        }
        this.add(INDENT + varName + " = DictionaryObject()");
    }

    protected void endCreateObject(String varName) {
        this.endFunction();
        if (--this.objectDepth > 0) {
            this.startFunction();
        }
    }

    private void startFunction() {
        this.shouldOpenFunction = true;
        this.functionOpened = false;
    }

    private void endFunction() {
        if (this.functionOpened) {
            super.add("_vars_" + this.currentFunctionNumber + "()");
            this.functionOpened = false;
        }
    }

    public void add(String line) {
        if (this.shouldOpenFunction && !this.functionOpened) {
            super.add("def _vars_" + ++this.currentFunctionNumber + "():");
            this.shouldOpenFunction = false;
            this.functionOpened = true;
        }
        super.add(line);
    }

    protected void setNullProperty(String objectName, String propertyName) {
        this.setNullVariable(INDENT + objectName + "." + propertyName);
    }

    protected void setEmptyCollectionProperty(String objectName, String propertyName) {
        this.add(INDENT + objectName + "." + propertyName + " = []");
    }

    protected void setEmptyMapProperty(String objectName, String propertyName) {
        this.add(INDENT + objectName + "." + propertyName + " = {}");
    }

    protected void setBooleanProperty(String objectName, String propertyName, boolean varValue) {
        this.setBooleanVariable(INDENT + objectName + "." + propertyName, varValue);
    }

    protected void setIntegerProperty(String objectName, String propertyName, int varValue) {
        this.setIntegerVariable(INDENT + objectName + "." + propertyName, varValue);
    }

    protected void setStringProperty(String objectName, String propertyName, String varValue) {
        this.setStringVariable(INDENT + objectName + "." + propertyName, varValue);
    }

    protected void setPasswordProperty(String objectName, String propertyName, String varValue) {
        this.add(INDENT + objectName + "." + propertyName + " = base64.decodestring(" + PythonVarsConverter.toPythonString(Base64.encodeBase64String((byte[])varValue.getBytes())) + ")");
    }

    protected void setCollectionOfStringsProperty(String objectName, String propertyName, Collection<?> varValue) {
        this.setCollectionOfStringsVariable(INDENT + objectName + "." + propertyName, varValue);
    }

    protected void setCiReferenceProperty(String objectName, String propertyName, ConfigurationItem varValue) {
        this.add(INDENT + objectName + "." + propertyName + " = " + this.getConfigurationItemVariableName(varValue));
    }

    protected void setCollectionOfCiReferencesProperty(String objectName, String propertyName, Collection<ConfigurationItem> varValue) {
        if (varValue.isEmpty()) {
            this.add(INDENT + objectName + "." + propertyName + " = []");
        } else {
            ArrayList referencedVarNames = Lists.newArrayList();
            for (ConfigurationItem setItem : varValue) {
                referencedVarNames.add(this.getConfigurationItemVariableName(setItem));
            }
            this.add(INDENT + objectName + "." + propertyName + " = [" + Joiner.on((String)", ").join((Iterable)referencedVarNames) + "]");
        }
    }

    protected void setMapOfStringToStringReferencesProperty(String objectName, String propertyName, Map<String, String> varValue) {
        if (varValue.isEmpty()) {
            this.setEmptyMapProperty(objectName, propertyName);
        } else {
            ArrayList entries = Lists.newArrayList();
            for (String key : varValue.keySet()) {
                String value = varValue.get(key);
                if (value == null) {
                    entries.add(PythonVarsConverter.toPythonString(key) + ": None");
                    continue;
                }
                entries.add(PythonVarsConverter.toPythonString(key) + ": " + PythonVarsConverter.toPythonString(value));
            }
            this.add(INDENT + objectName + "." + propertyName + " = {" + Joiner.on((String)", ").join((Iterable)entries) + "}");
        }
    }

    protected void createObjectAndSetObjectProperty(String objectName, String propertyName) {
        String embeddedObjectVariableName = objectName + "." + propertyName;
        this.startCreateObject(embeddedObjectVariableName);
        this.endCreateObject(embeddedObjectVariableName);
    }

    public static String toPythonString(String str) {
        StringBuilder converted = new StringBuilder();
        converted.append("\"");
        block5: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\r': {
                    converted.append("\\r");
                    continue block5;
                }
                case '\n': {
                    converted.append("\\n");
                    continue block5;
                }
                case '\"': 
                case '\'': 
                case '\\': {
                    converted.append('\\');
                }
                default: {
                    converted.append(c);
                }
            }
        }
        converted.append("\"");
        return converted.toString();
    }
}

