/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.python;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.StageableStep;
import com.xebialabs.deployit.plugin.api.flow.StagedFile;
import com.xebialabs.deployit.plugin.api.flow.StagingContext;
import com.xebialabs.deployit.plugin.api.flow.StagingTarget;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.overthere.DefaultExecutionOutputHandler;
import com.xebialabs.deployit.plugin.python.PythonDaemon;
import com.xebialabs.deployit.plugin.python.PythonManagedDeployed;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.python.PythonVarsConverter;
import com.xebialabs.deployit.plugin.remoting.preview.PreviewOverthereConnection;
import com.xebialabs.deployit.plugin.remoting.scripts.ScriptUtils;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

abstract class PythonStep
implements PreviewStep,
StageableStep {
    private static final String BASE_RUNTIME_PATH = "python/runtime";
    private final PythonManagingContainer container;
    private final String scriptPath;
    private final Map<String, Object> pythonVars;
    private final String description;
    private boolean uploadArtifactData = true;
    private Preview preview;
    private static final Logger logger = LoggerFactory.getLogger(PythonStep.class);
    private static final Logger scriptsLogger = LoggerFactory.getLogger((String)"com.xebialabs.deployit.plugin.python.scripts");

    public PythonStep(PythonManagingContainer container, String scriptPath, Map<String, Object> pythonVars, String description) {
        this.container = (PythonManagingContainer)Preconditions.checkNotNull((Object)container, (Object)"container is null");
        this.scriptPath = (String)Preconditions.checkNotNull((Object)scriptPath, (Object)"scriptPath is null");
        this.pythonVars = (Map)Preconditions.checkNotNull(pythonVars, (Object)"pythonVars is null");
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description is null");
    }

    public void requestStaging(StagingContext ctx) {
        if (!this.uploadArtifactData) {
            return;
        }
        for (Map.Entry<String, Object> entry : this.pythonVars.entrySet()) {
            if (!(entry.getValue() instanceof Artifact)) continue;
            StagedFile stagedFile = ctx.stageArtifact((Artifact)entry.getValue(), (StagingTarget)this.container.getHost());
            this.pythonVars.put(entry.getKey() + "_stagedFile", stagedFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StepExitCode doExecute(ExecutionContext ctx) throws Exception {
        MDC.put((String)"scriptPath", (String)this.scriptPath);
        try {
            OverthereConnection conn;
            block8: {
                StepExitCode stepExitCode;
                conn = this.container.getHost().getConnection();
                try {
                    String generatedScript = this.aggregateScript(conn, ctx);
                    PythonStep.dumpPythonScript(OverthereUtils.getName((String)this.scriptPath), generatedScript);
                    OverthereFile uploadedScriptFile = ScriptUtils.uploadScript((OverthereConnection)conn, (String)this.scriptPath, (String)generatedScript);
                    int res = this.executePythonScript(ctx, conn, uploadedScriptFile);
                    logger.debug("Exit code: {}", (Object)res);
                    if (res != 0) break block8;
                    stepExitCode = StepExitCode.SUCCESS;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((Closeable)conn);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)conn);
                return stepExitCode;
            }
            StepExitCode stepExitCode = StepExitCode.FAIL;
            IOUtils.closeQuietly((Closeable)conn);
            return stepExitCode;
        }
        finally {
            MDC.remove((String)"scriptPath");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preview getPreview() {
        if (this.preview == null) {
            try (OverthereConnection poc = PreviewOverthereConnection.getPreviewConnection();){
                String contents = this.aggregateScript(poc, null);
                this.preview = Preview.withSourcePathAndContents((String)this.scriptPath, (String)contents);
            }
        }
        return this.preview;
    }

    protected String aggregateScript(OverthereConnection connection, ExecutionContext ctx) {
        String pythonVarsPython = PythonVarsConverter.javaToPython(connection, this.pythonVars, this.uploadArtifactData, ctx);
        StringBuilder b = new StringBuilder();
        if (!this.container.runWithDaemon() || !connection.canStartProcess()) {
            PythonStep.appendRuntimeScripts(this.container, b);
        }
        this.appendDeployedRuntimeScripts(b);
        b.append("# PythonVars\n");
        b.append(pythonVarsPython);
        if (!this.container.runWithDaemon() || !connection.canStartProcess()) {
            b.append("#\nconnectFromStandAloneScript()\n");
        }
        b.append(ScriptUtils.loadScript((String)this.scriptPath));
        if (!this.container.runWithDaemon() || !connection.canStartProcess()) {
            b.append("#\ndisconnectFromStandAloneScript()\n");
        }
        return b.toString();
    }

    static void appendRuntimeScripts(PythonManagingContainer c, StringBuilder b) {
        PythonStep.appendBaseRuntimeScripts(b);
        PythonStep.appendContainerRuntimeScripts(c, b);
        PythonStep.appendContainerLibraryScripts(c, b);
    }

    private static void appendBaseRuntimeScripts(StringBuilder b) {
        ScriptUtils.appendScriptDir((String)BASE_RUNTIME_PATH, (StringBuilder)b);
    }

    private static void appendContainerRuntimeScripts(PythonManagingContainer c, StringBuilder b) {
        ScriptUtils.appendScriptDir((String)c.getRuntimePath(), (StringBuilder)b);
    }

    private static void appendContainerLibraryScripts(PythonManagingContainer c, StringBuilder b) {
        if (c.hasProperty("libraryScripts")) {
            List scripts = (List)c.getProperty("libraryScripts");
            ScriptUtils.appendScripts((List)scripts, (StringBuilder)b);
        }
    }

    private void appendDeployedRuntimeScripts(StringBuilder b) {
        PythonManagedDeployed deployed = (PythonManagedDeployed)((Object)this.pythonVars.get("deployed"));
        PythonManagedDeployed pythonManagedDeployed = deployed = deployed == null ? (PythonManagedDeployed)((Object)this.pythonVars.get("prototype")) : deployed;
        if (deployed != null) {
            for (String script : deployed.getLibraryScripts()) {
                b.append(ScriptUtils.loadScript((String)script));
            }
        }
    }

    private int executePythonScript(ExecutionContext ctx, OverthereConnection conn, OverthereFile script) {
        if (this.container.runWithDaemon() && conn.canStartProcess()) {
            return this.getDaemon(ctx).executePythonScript(ctx, script);
        }
        return this.executePythonScriptDirectly(ctx, conn, script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executePythonScriptDirectly(ExecutionContext ctx, OverthereConnection conn, OverthereFile script) {
        logger.info("Executing Python script {} on {} (without daemon)", (Object)script, (Object)conn);
        DefaultExecutionOutputHandler stdoutHandler = DefaultExecutionOutputHandler.handleStdout((ExecutionContext)ctx);
        DefaultExecutionOutputHandler stderrHandler = DefaultExecutionOutputHandler.handleStderr((ExecutionContext)ctx);
        try {
            int n = conn.execute((OverthereExecutionOutputHandler)stdoutHandler, (OverthereExecutionOutputHandler)stderrHandler, this.container.getScriptCommandLine(script));
            return n;
        }
        finally {
            IOUtils.closeQuietly((Closeable)stdoutHandler);
            IOUtils.closeQuietly((Closeable)stderrHandler);
        }
    }

    private PythonDaemon getDaemon(ExecutionContext context) {
        String key = "DAEMON_" + this.container.getId();
        PythonDaemon daemon = (PythonDaemon)context.getAttribute(key);
        if (daemon == null || !daemon.isAlive()) {
            daemon = new PythonDaemon(this.container);
            context.setAttribute(key, (Object)daemon);
            daemon.start(context);
        }
        return daemon;
    }

    String getScriptPath() {
        return this.scriptPath;
    }

    Map<String, Object> getPythonVars() {
        return this.pythonVars;
    }

    public void setUploadArtifactData(boolean uploadArtifactData) {
        this.uploadArtifactData = uploadArtifactData;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.scriptPath;
    }

    public static void dumpPythonScript(String scriptName, String scriptContents) {
        ScriptUtils.dumpScript((String)scriptName, (String)scriptContents, (Logger)scriptsLogger);
    }
}

