/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.python;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagedContainer;
import java.util.HashMap;
import java.util.Map;

public abstract class PythonManagedDeployed<D extends Deployable, C extends PythonManagedContainer>
extends BaseDeployed<D, C> {
    @Property(required=false, hidden=true, defaultValue="false", description="flag to indicate whether the deployed application CI is to be injected to the python script execution context.")
    private boolean exposeDeployedApplication;

    protected boolean addStep(DeploymentPlanningContext ctx, int order, String scriptPath, String verb) {
        return this.addStep(ctx, order, scriptPath, verb, true);
    }

    protected boolean addStep(DeploymentPlanningContext ctx, int order, String scriptPath, String verb, boolean uploadArtifactData) {
        if (scriptPath != null) {
            PythonDeploymentStep step = new PythonDeploymentStep(order, ((PythonManagedContainer)this.getContainer()).getManagingContainer(), scriptPath, this.getPythonVars(ctx.getDeployedApplication()), this.getDescription(verb));
            step.setUploadArtifactData(uploadArtifactData);
            ctx.addStep((DeploymentStep)step);
            return true;
        }
        return false;
    }

    protected boolean addStep(InspectionPlanningContext ctx, String scriptPath, String verb) {
        if (scriptPath != null) {
            ctx.addStep((Step)new PythonInspectionStep((ConfigurationItem)this, ((PythonManagedContainer)this.getContainer()).getManagingContainer(), scriptPath, this.getPythonVars(null), this.getDescription(verb)));
            return true;
        }
        return false;
    }

    protected Map<String, Object> getPythonVars() {
        return this.getPythonVars(null);
    }

    protected Map<String, Object> getPythonVars(DeployedApplication deployedApplication) {
        HashMap pythonVars = Maps.newHashMap();
        pythonVars.put("deployed", this);
        if (this.exposeDeployedApplication) {
            Preconditions.checkNotNull((Object)deployedApplication, (Object)"deployedApplication is null");
            pythonVars.put("deployedApplication", deployedApplication);
        }
        return pythonVars;
    }

    protected String getDescription(String verb) {
        return String.format("%s %s on %s", verb, this.getName(), ((PythonManagedContainer)this.getContainer()).getName());
    }

    public boolean getExposeDeployedApplication() {
        return this.exposeDeployedApplication;
    }

    public void setExposeDeployedApplication(boolean exposeDeployedApplication) {
        this.exposeDeployedApplication = exposeDeployedApplication;
    }
}

