/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.python;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContextListener;
import com.xebialabs.deployit.plugin.python.PythonDaemonException;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.python.PythonStep;
import com.xebialabs.deployit.plugin.python.PythonVarsConverter;
import com.xebialabs.deployit.plugin.remoting.scripts.ScriptUtils;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PythonDaemon
implements ExecutionContextListener {
    private static final String DAEMON_SCRIPT = "python/daemon/daemon.py";
    private static final String DAEMON_STARTED = "DEPLOYIT-DAEMON-STARTED";
    private static final String DAEMON_EXIT_CODE_MARKER = "DEPLOYIT-DAEMON-EXIT-VALUE: ";
    private static final String DAEMON_END_OF_STDOUT_MARKER = "DEPLOYIT-DAEMON-END-OF-STDOUT";
    private static final String DAEMON_END_OF_STDERR_MARKER = "DEPLOYIT-DAEMON-END-OF-STDERR";
    private static final int FLUSH_DELAY_MS = 5000;
    private static final int FLUSH_CHECK_INTERVAL_MS = 2000;
    private static final Timer flushTimer = new Timer("PythonDaemon-AutoFlushTimer", true);
    private final PythonManagingContainer container;
    private OverthereConnection connection;
    private OverthereProcess process;
    private static final Logger logger = LoggerFactory.getLogger(PythonDaemon.class);

    PythonDaemon(PythonManagingContainer container) {
        this.container = container;
    }

    void start(ExecutionContext context) {
        context.logOutput("Starting Python daemon on " + this.container.getHost());
        this.connection = this.container.getHost().getConnection();
        logger.info("Starting Python daemon on {}", (Object)this.connection);
        OverthereFile uploadedDaemonScript = this.uploadDaemonScript();
        this.waitForDaemonStart(context, uploadedDaemonScript);
    }

    protected OverthereFile uploadDaemonScript() {
        String daemonScript = this.generateDaemonScript();
        PythonStep.dumpPythonScript("daemon.py", daemonScript);
        return ScriptUtils.uploadScript((OverthereConnection)this.connection, (String)"daemon.py", (String)daemonScript);
    }

    private String generateDaemonScript() {
        StringBuilder b = new StringBuilder();
        b.append(ScriptUtils.loadScriptDir((String)"python/runtime"));
        b.append(ScriptUtils.loadScriptDir((String)this.container.getRuntimePath()));
        b.append("#\nconnectFromDaemon()\n");
        b.append(ScriptUtils.loadScript((String)DAEMON_SCRIPT));
        b.append("#\ndisconnectFromDaemon()\n");
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForDaemonStart(final ExecutionContext context, OverthereFile uploadedDaemonScript) {
        block17: {
            this.process = this.connection.startProcess(this.container.getScriptCommandLine(uploadedDaemonScript));
            InputStreamReader stdout = new InputStreamReader(this.process.getStdout());
            final StringBuilder stdoutLineBuffer = new StringBuilder();
            final long[] flushAfter = new long[1];
            TimerTask flushTimerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    StringBuilder stringBuilder = stdoutLineBuffer;
                    synchronized (stringBuilder) {
                        if (flushAfter[0] < System.currentTimeMillis()) {
                            if (stdoutLineBuffer.length() > 0) {
                                context.logOutput(stdoutLineBuffer.toString());
                                stdoutLineBuffer.setLength(0);
                            }
                            flushAfter[0] = System.currentTimeMillis() + 5000L;
                        }
                    }
                }
            };
            flushTimer.schedule(flushTimerTask, 5000L, 2000L);
            while (true) {
                try {
                    StringBuilder stringBuilder;
                    char c;
                    do {
                        int cInt;
                        if ((cInt = stdout.read()) == -1) {
                            this.captureStderr(context, this.process);
                            int exitCode = -1;
                            try {
                                exitCode = this.process.waitFor();
                            }
                            catch (InterruptedException exc) {
                                logger.error("Interrupted while waiting for " + this.process + " to complete");
                                Thread.currentThread().interrupt();
                            }
                            throw new PythonDaemonException("Cannot start python daemon: exit code " + exitCode);
                        }
                        c = (char)cInt;
                        if (c == '\r' || c == '\n') continue;
                        stringBuilder = stdoutLineBuffer;
                        synchronized (stringBuilder) {
                            stdoutLineBuffer.append(c);
                        }
                    } while (c != '\n');
                    stringBuilder = stdoutLineBuffer;
                    synchronized (stringBuilder) {
                        flushAfter[0] = System.currentTimeMillis() + 5000L;
                        String stdoutLine = stdoutLineBuffer.toString();
                        context.logOutput(stdoutLine);
                        stdoutLineBuffer.setLength(0);
                        if (stdoutLine.startsWith(DAEMON_STARTED)) {
                            break block17;
                        }
                    }
                }
                catch (IOException exc) {
                    throw new PythonDaemonException("Cannot start python daemon", exc);
                }
            }
            finally {
                flushTimerTask.cancel();
            }
        }
    }

    private void captureStderr(ExecutionContext context, OverthereProcess daemonProcess) throws IOException {
        String stderrLine;
        BufferedReader stderr = new BufferedReader(new InputStreamReader(daemonProcess.getStderr()));
        while ((stderrLine = stderr.readLine()) != null) {
            context.logError(stderrLine);
        }
    }

    int executePythonScript(final ExecutionContext ctx, OverthereFile script) {
        try {
            logger.info("Executing Python script {} on {} (with daemon)", (Object)script, (Object)this.connection);
            String daemonLine = "runScriptFromDaemon(" + PythonVarsConverter.toPythonString(script.getPath()) + ")\n";
            OutputStream stdin = this.process.getStdin();
            stdin.write(daemonLine.getBytes());
            stdin.flush();
            BufferedReader stdout = new BufferedReader(new InputStreamReader(this.process.getStdout()));
            final BufferedReader stderr = new BufferedReader(new InputStreamReader(this.process.getStderr()));
            Thread stderrThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String stderrLine;
                        while (!Thread.interrupted() && (stderrLine = stderr.readLine()) != null && !stderrLine.equals(PythonDaemon.DAEMON_END_OF_STDERR_MARKER)) {
                            ctx.logError(stderrLine);
                        }
                    }
                    catch (InterruptedIOException ie) {
                        Thread.currentThread().interrupt();
                    }
                    catch (IOException exc) {
                        exc.printStackTrace();
                    }
                }
            }, "stderr printer for python daemon running on " + this);
            stderrThread.start();
            int exitCode = 0;
            while (true) {
                String stdoutLine;
                if ((stdoutLine = stdout.readLine()) == null) {
                    throw new RuntimeIOException("Cannot execute script " + script.getPath() + " on " + this.container.getHost() + ": lost connection to the python daemon");
                }
                if (stdoutLine.startsWith(DAEMON_EXIT_CODE_MARKER)) {
                    try {
                        exitCode = Integer.parseInt(stdoutLine.substring(DAEMON_EXIT_CODE_MARKER.length()));
                    }
                    catch (NumberFormatException ignored) {}
                    continue;
                }
                if (stdoutLine.equals(DAEMON_END_OF_STDOUT_MARKER)) break;
                if (stdoutLine.equals(DAEMON_END_OF_STDERR_MARKER)) {
                    stderrThread.interrupt();
                    continue;
                }
                ctx.logOutput(stdoutLine);
            }
            try {
                stderrThread.join();
            }
            catch (InterruptedException exc) {
                logger.error("Interrupted while waiting for " + stderrThread + " to complete");
                Thread.currentThread().interrupt();
            }
            return exitCode;
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot execute script " + script.getPath() + " on " + this.container.getHost(), (Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed() {
        OutputStream stdin = this.process.getStdin();
        try {
            stdin.write("QUIT\r\n".getBytes());
            stdin.flush();
            this.process.waitFor();
        }
        catch (IOException exc) {
            logger.error("Error stopping python daemon", (Throwable)exc);
        }
        catch (RuntimeException exc) {
            logger.error("Error stopping python daemon", (Throwable)exc);
        }
        catch (InterruptedException exc) {
            logger.error("Error stopping python daemon", (Throwable)exc);
        }
        finally {
            Closeables.closeQuietly((Closeable)this.connection);
        }
    }
}

