/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.python;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.ReflectionsHolder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.python.DerivedProperty;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;

public class PythonVarsConverter {
    public static final String EMBEDDED_OBJECT_INDICATOR = "_";

    public static String javaToPython(OverthereConnection connection, Map<String, Object> pythonVars) {
        List<String> pythonList = PythonVarsConverter.javaToPythonList(connection, pythonVars);
        return Joiner.on((String)"\n").join(pythonList) + "\n";
    }

    static List<String> javaToPythonList(OverthereConnection connection, Map<String, Object> pythonVars) {
        return new PythonVarsConverterContext(connection, pythonVars).toPythonList();
    }

    public static String toPythonString(String str) {
        StringBuilder converted = new StringBuilder();
        converted.append("\"");
        block5: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\r': {
                    converted.append("\\r");
                    continue block5;
                }
                case '\n': {
                    converted.append("\\n");
                    continue block5;
                }
                case '\"': 
                case '\'': 
                case '\\': {
                    converted.append('\\');
                }
                default: {
                    converted.append(c);
                }
            }
        }
        converted.append("\"");
        return converted.toString();
    }

    private static class PythonVarsConverterContext {
        private static final String PYTHON_PROPERTIES_VARIABLE_NAME = "._properties";
        public static final String GENERATED_VARIABLE_PREFIX = "_pv";
        private OverthereConnection connection;
        Map<String, Object> pythonVars;
        List<String> python = Lists.newArrayList();
        Map<Object, String> alreadyConvertedCis = Maps.newIdentityHashMap();
        Map<String, String> propertyFullPathMap = Maps.newHashMap();
        int nextVarNumber = 1;

        PythonVarsConverterContext(OverthereConnection connection, Map<String, Object> pythonVars) {
            this.connection = connection;
            this.pythonVars = pythonVars;
        }

        List<String> toPythonList() {
            TreeSet sortedKeys = Sets.newTreeSet(this.pythonVars.keySet());
            for (String varName : sortedKeys) {
                Object varValue = this.pythonVars.get(varName);
                this.toPython(varName, varValue);
            }
            return this.python;
        }

        private void toPython(String varName, Object varValue) {
            if (varValue == null) {
                this.appendNullVar(varName);
            } else if (varValue instanceof Boolean) {
                this.appendBooleanVar(varName, (Boolean)varValue);
            } else if (varValue instanceof Integer) {
                this.appendIntegerVar(varName, (Integer)varValue);
            } else if (varValue instanceof Long) {
                this.appendLongVar(varName, (Long)varValue);
            } else if (varValue instanceof ConfigurationItem) {
                this.alreadyConvertedCis.put(varValue, varName);
                this.appendConfigurationItemVar(varName, (ConfigurationItem)varValue);
            } else if (varValue instanceof Collection) {
                this.appendCollectionVar(varName, (Collection)varValue);
            } else {
                this.appendStringVar(varName, varValue.toString());
            }
        }

        void appendConfigurationItemVar(String varName, ConfigurationItem item) {
            Descriptor d = DescriptorRegistry.getDescriptor((Type)item.getType());
            if (d == null) {
                throw new IllegalArgumentException("Python var " + varName + " is a ConfigurationItem of an unknown type: " + item.getType());
            }
            this.python.add(varName + " = DictionaryObject()");
            this.appendEmbeddedObjectDefinitions(varName, d);
            this.makePropertyFullPathsMap(varName, d);
            this.appendConfigurationItemVarMetaData(varName, item, d);
            this.appendRegularPropertiesToConfigurationItemVar(varName, item, d);
            this.appendDerivedPropertiesToConfigurationItemVar(varName, item);
            this.appendArtifactPropertiesToConfigurationItemVar(varName, item);
        }

        private void appendEmbeddedObjectDefinitions(String rootObjectName, Descriptor descriptor) {
            this.renderEmbeddedObjects(this.extractEmbeddedObjectsAndAttributes(rootObjectName, descriptor));
        }

        private void renderEmbeddedObjects(Multimap<String, String> objectAttributesKeyedByObjectName) {
            for (String absoluteObjectName : objectAttributesKeyedByObjectName.keySet()) {
                this.python.add(absoluteObjectName + " = DictionaryObject()");
                StringBuilder embeddedObjectProperties = new StringBuilder();
                for (String p : objectAttributesKeyedByObjectName.get((Object)absoluteObjectName)) {
                    if (embeddedObjectProperties.length() > 0) {
                        embeddedObjectProperties.append(", ");
                    }
                    embeddedObjectProperties.append(PythonVarsConverter.toPythonString(p));
                }
                this.python.add(absoluteObjectName + PYTHON_PROPERTIES_VARIABLE_NAME + " = [" + embeddedObjectProperties.toString() + "]");
            }
        }

        private Multimap<String, String> extractEmbeddedObjectsAndAttributes(String rootObjectName, Descriptor descriptor) {
            ArrayListMultimap objectAttributesKeyedByObjectName = ArrayListMultimap.create();
            for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
                if (!this.isEmbeddedObjectStylePropertyName(pd.getName())) continue;
                String absoluteObjectName = rootObjectName + "." + pd.getName().replaceAll(PythonVarsConverter.EMBEDDED_OBJECT_INDICATOR, ".");
                String attributeName = absoluteObjectName.substring(absoluteObjectName.lastIndexOf(".") + 1);
                absoluteObjectName = absoluteObjectName.substring(0, absoluteObjectName.lastIndexOf("."));
                objectAttributesKeyedByObjectName.put((Object)absoluteObjectName, (Object)attributeName);
            }
            for (String absoluteObjectName : objectAttributesKeyedByObjectName.keySet()) {
                String absoluteParentObjectName = absoluteObjectName.substring(0, absoluteObjectName.lastIndexOf("."));
                String objectName = absoluteObjectName.substring(absoluteObjectName.lastIndexOf(".") + 1);
                if (!objectAttributesKeyedByObjectName.containsKey((Object)absoluteParentObjectName)) continue;
                objectAttributesKeyedByObjectName.get((Object)absoluteParentObjectName).add(objectName);
            }
            return objectAttributesKeyedByObjectName;
        }

        private boolean isEmbeddedObjectStylePropertyName(String propName) {
            return propName.contains(PythonVarsConverter.EMBEDDED_OBJECT_INDICATOR);
        }

        private void makePropertyFullPathsMap(String varName, Descriptor descriptor) {
            this.propertyFullPathMap.put(varName + ".id", varName + ".id");
            this.propertyFullPathMap.put(varName + ".name", varName + ".name");
            for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
                String propName = varName + "." + pd.getName();
                String propertyName = pd.getName().replaceAll(PythonVarsConverter.EMBEDDED_OBJECT_INDICATOR, ".");
                String propertyFullPath = varName + "." + propertyName;
                if (this.propertyFullPathMap.containsKey(propName)) continue;
                this.propertyFullPathMap.put(propName, propertyFullPath);
            }
        }

        private void appendConfigurationItemVarMetaData(String varName, ConfigurationItem item, Descriptor d) {
            this.appendStringVar(varName + ".id", item.getId());
            this.appendStringVar(varName + ".name", item.getName());
            HashSet attributes = Sets.newHashSet((Object[])new String[]{"id", "name"});
            for (PropertyDescriptor pd : d.getPropertyDescriptors()) {
                if (!this.isEmbeddedObjectStylePropertyName(pd.getName())) {
                    attributes.add(pd.getName());
                    continue;
                }
                attributes.add(pd.getName().substring(0, pd.getName().indexOf(PythonVarsConverter.EMBEDDED_OBJECT_INDICATOR)));
            }
            Set methodsAnnotatedWith = ReflectionsHolder.getMethodsAnnotatedWith(DerivedProperty.class);
            Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)item.getType());
            for (Method method : methodsAnnotatedWith) {
                if (!descriptor.isAssignableTo(method.getDeclaringClass())) continue;
                DerivedProperty derivedProperty = method.getAnnotation(DerivedProperty.class);
                attributes.add(derivedProperty.value());
            }
            StringBuilder properties = new StringBuilder();
            for (String attribute : attributes) {
                if (properties.length() > 0) {
                    properties.append(", ");
                }
                properties.append(PythonVarsConverter.toPythonString(attribute));
            }
            this.appendRawVar(varName + PYTHON_PROPERTIES_VARIABLE_NAME, "[" + properties.toString() + "]");
        }

        private void appendRegularPropertiesToConfigurationItemVar(String varName, ConfigurationItem item, Descriptor d) {
            block9: for (PropertyDescriptor pd : d.getPropertyDescriptors()) {
                String propertyName = varName + "." + pd.getName();
                Object propertyValue = pd.get(item);
                switch (pd.getKind()) {
                    case BOOLEAN: {
                        propertyName = this.propertyFullPathMap.get(propertyName);
                        if (propertyValue == null) {
                            this.appendNullVar(propertyName);
                            continue block9;
                        }
                        if (!(propertyValue instanceof Boolean)) {
                            throw new IllegalStateException("Property " + propertyName + " is not a Boolean but a " + propertyValue.getClass().getName());
                        }
                        this.appendBooleanVar(propertyName, (Boolean)propertyValue);
                        continue block9;
                    }
                    case INTEGER: {
                        propertyName = this.propertyFullPathMap.get(propertyName);
                        if (propertyValue == null) {
                            this.appendNullVar(propertyName);
                            continue block9;
                        }
                        if (!(propertyValue instanceof Integer)) {
                            throw new IllegalStateException("Property " + propertyName + " is not an Integer but a " + propertyValue.getClass().getName());
                        }
                        this.appendIntegerVar(propertyName, (Integer)propertyValue);
                        continue block9;
                    }
                    case SET_OF_STRING: {
                        if (propertyValue == null) {
                            this.appendEmptySetVar(propertyName);
                            continue block9;
                        }
                        if (!(propertyValue instanceof Set)) {
                            throw new IllegalStateException("Property " + propertyName + " is not a Set but a " + propertyValue.getClass().getName());
                        }
                        this.appendCollectionVar(propertyName, (Set)propertyValue);
                        continue block9;
                    }
                    case CI: {
                        if (d.isAssignableTo(Type.valueOf(Deployed.class)) && pd.getName().equals("deployable")) {
                            this.appendNullVar(propertyName);
                            continue block9;
                        }
                        if (propertyValue == null) {
                            this.appendNullVar(propertyName);
                            continue block9;
                        }
                        if (!(propertyValue instanceof ConfigurationItem)) {
                            throw new IllegalStateException("Property " + propertyName + " is not a ConfigurationItem but a " + propertyValue.getClass().getName());
                        }
                        this.appendCiReferenceVar(propertyName, (ConfigurationItem)propertyValue);
                        continue block9;
                    }
                    case SET_OF_CI: {
                        if (propertyValue == null) {
                            this.appendEmptySetVar(propertyName);
                            continue block9;
                        }
                        if (!(propertyValue instanceof Set)) {
                            throw new IllegalStateException("Property " + propertyName + " is not a Set but a " + propertyValue.getClass().getName());
                        }
                        this.appendSetOfCiReferencesVar(propertyName, (Set)propertyValue);
                        continue block9;
                    }
                    case MAP_STRING_STRING: {
                        propertyName = this.propertyFullPathMap.get(propertyName);
                        if (propertyValue == null) {
                            this.appendEmptyMapVar(propertyName);
                            continue block9;
                        }
                        if (!(propertyValue instanceof Map)) {
                            throw new IllegalStateException("Property " + propertyName + " is not a Map but a " + propertyValue.getClass().getName());
                        }
                        this.appendMapOfStringsReferencesVar(propertyName, (Map)propertyValue);
                        continue block9;
                    }
                    case STRING: 
                    case ENUM: {
                        propertyName = this.propertyFullPathMap.get(propertyName);
                        if (propertyValue == null) {
                            this.appendNullVar(propertyName);
                            continue block9;
                        }
                        if (pd.isPassword()) {
                            this.appendPasswordVar(propertyName, propertyValue.toString());
                            continue block9;
                        }
                        this.appendStringVar(propertyName, propertyValue.toString());
                        continue block9;
                    }
                }
                throw new IllegalStateException("Should not end up here!");
            }
        }

        void appendDerivedPropertiesToConfigurationItemVar(String varName, ConfigurationItem item) {
            Set methodsAnnotatedWith = ReflectionsHolder.getMethodsAnnotatedWith(DerivedProperty.class);
            Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)item.getType());
            for (Method method : methodsAnnotatedWith) {
                if (!descriptor.isAssignableTo(method.getDeclaringClass())) continue;
                DerivedProperty derivedProperty = method.getAnnotation(DerivedProperty.class);
                String propertyName = varName + "." + derivedProperty.value();
                try {
                    this.toPython(propertyName, method.invoke((Object)item, new Object[0]));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Method " + method.getName() + " in class " + method.getClass() + " cannot be accessed.", e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Method " + method.getName() + " in class " + method.getClass() + " cannot be invoked.", e);
                }
            }
        }

        private void appendArtifactPropertiesToConfigurationItemVar(String varName, ConfigurationItem item) {
            if (item instanceof Artifact) {
                Artifact a = (Artifact)item;
                Preconditions.checkNotNull((Object)a.getFile(), (Object)(a + " has a null file"));
                OverthereFile uploadedFileArtifact = this.connection.getTempFile(a.getFile().getName());
                a.getFile().copyTo(uploadedFileArtifact);
                this.appendStringVar(varName + ".file", uploadedFileArtifact.getPath());
            }
        }

        void appendNullVar(String varName) {
            this.python.add(varName + " = None");
        }

        private void appendEmptySetVar(String varName) {
            this.python.add(varName + " = []");
        }

        private void appendEmptyMapVar(String varName) {
            this.python.add(varName + " = {}");
        }

        void appendBooleanVar(String varName, Boolean varValue) {
            this.python.add(varName + " = " + (varValue != false ? "True" : "False"));
            this.python.add(varName + "_as_string = " + (varValue != false ? "'true'" : "'false'"));
        }

        void appendIntegerVar(String varName, Integer varValue) {
            this.python.add(varName + " = " + varValue);
        }

        void appendLongVar(String varName, Long varValue) {
            this.python.add(varName + " = " + varValue + "L");
        }

        void appendCollectionVar(String varName, Collection<?> varValue) {
            if (varValue.isEmpty()) {
                this.python.add(varName + " = []");
            } else {
                Collection encodedStrings = Collections2.transform(varValue, (Function)new Function<Object, String>(){

                    public String apply(Object input) {
                        return PythonVarsConverter.toPythonString(input.toString());
                    }
                });
                this.python.add(varName + " = [" + Joiner.on((String)", ").join((Iterable)encodedStrings) + "]");
            }
        }

        void appendStringVar(String varName, String varValue) {
            this.python.add(varName + " = " + PythonVarsConverter.toPythonString(varValue));
        }

        void appendPasswordVar(String varName, String varValue) {
            this.python.add(varName + " = base64.decodestring(" + PythonVarsConverter.toPythonString(Base64.encodeBase64String((byte[])varValue.getBytes())) + ")");
        }

        void appendRawVar(String varName, String varValue) {
            this.python.add(varName + " = " + varValue);
        }

        void appendCiReferenceVar(String varName, ConfigurationItem varValue) {
            this.python.add(varName + " = " + this.appendNewConfigurationItemVar(varValue));
        }

        void appendSetOfCiReferencesVar(String varName, Set<ConfigurationItem> varValue) {
            if (varValue.isEmpty()) {
                this.appendEmptySetVar(varName);
            } else {
                ArrayList varRefs = Lists.newArrayList();
                for (ConfigurationItem setItem : varValue) {
                    varRefs.add(this.appendNewConfigurationItemVar(setItem));
                }
                this.python.add(varName + " = [" + Joiner.on((String)", ").join((Iterable)varRefs) + "]");
            }
        }

        void appendMapOfStringsReferencesVar(String varName, Map<String, String> varValue) {
            if (varValue.isEmpty()) {
                this.appendEmptyMapVar(varName);
            } else {
                ArrayList varRefs = Lists.newArrayList();
                for (String key : varValue.keySet()) {
                    String value = varValue.get(key);
                    if (value == null) {
                        varRefs.add("" + PythonVarsConverter.toPythonString(key) + ": None");
                        continue;
                    }
                    varRefs.add("" + PythonVarsConverter.toPythonString(key) + ": " + PythonVarsConverter.toPythonString(value));
                }
                this.python.add(varName + " = {" + Joiner.on((String)", ").join((Iterable)varRefs) + "}");
            }
        }

        String appendNewConfigurationItemVar(ConfigurationItem item) {
            if (this.alreadyConvertedCis.containsKey(item)) {
                return this.alreadyConvertedCis.get(item);
            }
            String pvName = GENERATED_VARIABLE_PREFIX + this.nextVarNumber++;
            this.alreadyConvertedCis.put(item, pvName);
            this.appendConfigurationItemVar(pvName, item);
            return pvName;
        }
    }
}

