/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.powershell.BasePowershellVarsConverter;
import com.xebialabs.overthere.OverthereConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class PowerShellVarsConverter
extends BasePowershellVarsConverter {
    public static String javaToPowerShell(OverthereConnection connection, Map<String, Object> powershellVars, boolean maskPasswords, boolean exposePasswordPropertiesOnHosts) {
        return PowerShellVarsConverter.javaToPowerShell(connection, powershellVars, true, null, maskPasswords, exposePasswordPropertiesOnHosts);
    }

    public static String javaToPowerShell(OverthereConnection connection, Map<String, Object> powershellVars, boolean uploadArtifactData, ExecutionContext ctx, boolean maskPasswords, boolean exposePasswordPropertiesOnHosts) {
        List<String> powerShellList = PowerShellVarsConverter.javaToPowerShellList(connection, powershellVars, uploadArtifactData, ctx, maskPasswords, exposePasswordPropertiesOnHosts);
        return Joiner.on((String)"\n").join(powerShellList) + "\n";
    }

    static List<String> javaToPowerShellList(OverthereConnection connection, Map<String, Object> powershellVars, boolean uploadArtifactData, ExecutionContext ctx, boolean maskPasswords, boolean exposePasswordPropertiesOnHosts) {
        PowerShellVarsConverter converter = new PowerShellVarsConverter(connection, powershellVars, maskPasswords, exposePasswordPropertiesOnHosts);
        converter.setUploadArtifactData(uploadArtifactData);
        converter.setExecutionContext(ctx);
        return converter.convert();
    }

    PowerShellVarsConverter(OverthereConnection connection, Map<String, Object> powershellVars, boolean maskPasswords, boolean exposePasswordPropertiesOnHosts) {
        super(connection, powershellVars, maskPasswords, exposePasswordPropertiesOnHosts);
    }

    protected void setNullVariable(String variableName) {
        this.add("$" + variableName + " = $null");
    }

    protected void setBooleanVariable(String variableName, boolean variableValue) {
        this.add("$" + variableName + " = " + PowerShellVarsConverter.toPowerShellBoolean(variableValue));
    }

    protected void setIntegerVariable(String variableName, int variableValue) {
        this.add("$" + variableName + " = " + variableValue);
    }

    protected void setLongVariable(String variableName, long variableValue) {
        this.add("$" + variableName + " = " + variableValue);
    }

    protected void setStringVariable(String variableName, String variableValue) {
        this.add("$" + variableName + " = " + PowerShellVarsConverter.toPowerShellString(variableValue));
    }

    protected void setCollectionOfStringsVariable(String variableName, Collection<?> variableValue) {
        this.add("$" + variableName + " = " + PowerShellVarsConverter.toPowerShellCollectionOfStrings(variableValue));
    }

    protected void startCreateObject(String variableName) {
        this.add("$" + variableName + " = New-Object Object");
    }

    protected void setBooleanProperty(String objectName, String propertyName, boolean propertyValue) {
        this.setNoteProperty(objectName, propertyName, PowerShellVarsConverter.toPowerShellBoolean(propertyValue));
    }

    protected void setIntegerProperty(String objectName, String propertyName, int propertyValue) {
        this.setNoteProperty(objectName, propertyName, Integer.toString(propertyValue));
    }

    protected void setStringProperty(String objectName, String propertyName, String propertyValue) {
        this.setNoteProperty(objectName, propertyName, PowerShellVarsConverter.toPowerShellString(propertyValue));
    }

    protected void setPasswordProperty(String objectName, String propertyName, String propertyValue) {
        this.setNullProperty(objectName, propertyName);
        this.add("$" + objectName + "." + PowerShellVarsConverter.toPowerShellString(propertyName) + " = " + (this.maskPasswords ? PowerShellVarsConverter.toPowerShellString("********") : "([System.Text.Encoding]::Unicode.GetString([System.Convert]::FromBase64String(" + PowerShellVarsConverter.toPowerShellString(this.encodeBase64(propertyValue)) + ")))"));
    }

    protected void setCollectionOfStringsProperty(String objectName, String propertyName, Collection<?> propertyValue) {
        this.setNoteProperty(objectName, propertyName, PowerShellVarsConverter.toPowerShellCollectionOfStrings(propertyValue));
    }

    protected void setMapOfStringToStringReferencesProperty(String objectName, String propertyName, Map<String, String> propertyValue) {
        ArrayList entries = Lists.newArrayList();
        for (String key : propertyValue.keySet()) {
            String value = propertyValue.get(key);
            if (value == null) {
                entries.add(PowerShellVarsConverter.toPowerShellString(key) + " = $null");
                continue;
            }
            entries.add(PowerShellVarsConverter.toPowerShellString(key) + " = " + PowerShellVarsConverter.toPowerShellString(value));
        }
        this.setNoteProperty(objectName, propertyName, "@{" + Joiner.on((String)"; ").join((Iterable)entries) + "}");
    }

    public static String toPowerShellBoolean(Boolean bool) {
        return bool != false ? "$true" : "$false";
    }

    public static String toPowerShellCollectionOfStrings(Collection<?> variableValue) {
        Collection encodedStrings = Collections2.transform(variableValue, (Function)new Function<Object, String>(){

            public String apply(Object input) {
                return BasePowershellVarsConverter.toPowerShellString(input.toString());
            }
        });
        return "@(" + Joiner.on((String)", ").join((Iterable)encodedStrings) + ")";
    }
}

