/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.powershell.PowerShellContainer;
import com.xebialabs.deployit.plugin.remoting.preview.PreviewOverthereConnection;
import com.xebialabs.deployit.plugin.remoting.scripts.ScriptUtils;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.util.OverthereUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class PowerShellStepUtils {
    private static final String DEFAULT_POWER_SHELL_PATH = "powershell";
    private static Logger logger = LoggerFactory.getLogger(PowerShellStepUtils.class);
    private static final Logger scriptsLogger = LoggerFactory.getLogger((String)"com.xebialabs.deployit.plugin.powershell.scripts");

    public static Preview previewPowerShellScript(PowerShellScriptCallback callback) {
        try (OverthereConnection poc = PreviewOverthereConnection.getPreviewConnection();){
            String scriptPath = callback.getScriptPath();
            String generatedScript = callback.generateScript(poc);
            Preview preview = Preview.withSourcePathAndContents((String)scriptPath, (String)generatedScript);
            return preview;
        }
    }

    /*
     * Loose catch block
     */
    public static StepExitCode executePowerShellScript(HostContainer container, ExecutionContext ctx, PowerShellScriptCallback callback, PowerShellScriptCallback obfuscationCallback) throws Exception {
        String scriptPath = callback.getScriptPath();
        MDC.put((String)"scriptPath", (String)scriptPath);
        try {
            try (OverthereConnection conn = container.getHost().getConnection();){
                String generatedScript = callback.generateScript(conn);
                if (scriptsLogger.isTraceEnabled()) {
                    String obfuscatedScript = obfuscationCallback.generateScript(conn);
                    ScriptUtils.dumpScript((String)OverthereUtils.getName((String)scriptPath), (String)obfuscatedScript, (Logger)scriptsLogger);
                }
                OverthereFile uploadedScriptFile = ScriptUtils.uploadScript((OverthereConnection)conn, (String)scriptPath, (String)generatedScript);
                callback.uploadAdditionalResources(container, ctx, conn);
                int res = PowerShellStepUtils.executePowerShellScript(container, ctx, conn, uploadedScriptFile);
                logger.debug("Exit code: [{}]", (Object)res);
                if (res == 0) {
                    StepExitCode stepExitCode = StepExitCode.SUCCESS;
                    return stepExitCode;
                }
                StepExitCode stepExitCode = StepExitCode.FAIL;
                return stepExitCode;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            MDC.remove((String)"scriptPath");
        }
    }

    /*
     * Exception decompiling
     */
    private static int executePowerShellScript(HostContainer container, ExecutionContext ctx, OverthereConnection conn, OverthereFile script) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static CmdLine getScriptCommandLine(HostContainer container, OverthereFile script) {
        CmdLine cmdLine = container instanceof PowerShellContainer ? ((PowerShellContainer)container).getScriptCommandLine(script) : PowerShellStepUtils.getDefaultScriptCommandLine(DEFAULT_POWER_SHELL_PATH, script);
        return cmdLine;
    }

    public static CmdLine getDefaultScriptCommandLine(String powerShellPath, OverthereFile script) {
        return CmdLine.build((String[])new String[]{powerShellPath, "-ExecutionPolicy", "Unrestricted", "-Inputformat", "None", "-NonInteractive", "-NoProfile", "-Command", "$ErrorActionPreference = 'Stop'; & " + script.getPath() + "; if($LastExitCode) { Exit $LastExitCode; }"});
    }

    static interface PowerShellScriptCallback {
        public String getScriptPath();

        public String generateScript(OverthereConnection var1);

        public void uploadAdditionalResources(HostContainer var1, ExecutionContext var2, OverthereConnection var3);
    }
}

