/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.powershell.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.powershell.PowerShellDeploymentStep;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(virtual=true)
public class BasePowerShellDeployed<D extends Deployable, C extends HostContainer>
extends BaseDeployed<D, C> {
    public static final String STEP_OPTION_NONE = "none";
    public static final String STEP_OPTION_UPLOAD_ARTIFACT_DATA = "uploadArtifactData";
    public static final String STEP_OPTION_EXPOSE_PREVIOUS_DEPLOYED = "exposePreviousDeployed";
    public static final String STEP_OPTION_EXPOSE_DEPLOYED_APPLICATION = "exposeDeployedApplication";
    public static final String STEP_OPTIONS_REGEX = "(none|uploadArtifactData|exposePreviousDeployed|exposeDeployedApplication)";
    public static final String STEP_OPTIONS_DESCRIPTION_SUFFIX = " (1 or more of: none,uploadArtifactData,exposePreviousDeployed,exposeDeployedApplication).";
    @Property(required=false, hidden=true, description="List of scripts to append to the the step script.")
    private List<String> libraryScripts = Lists.newArrayList();
    @Property(hidden=true, defaultValue="50", description="Order at which the discover step will be executed.")
    private int discoverOrder;
    @Property(hidden=true, required=false, description="Script invoked to discover and inspect deployeds of this type.")
    private String discoverScript;

    public boolean addStep(DeploymentPlanningContext ctx, Delta delta, int order, String scriptPath, String verb, Set<String> options) {
        return this.addStep(ctx, delta, null, order, scriptPath, verb, options);
    }

    public boolean addStepWithCheckpoint(DeploymentPlanningContext ctx, Delta delta, Operation operation, int order, String scriptPath, String verb, Set<String> options) {
        Preconditions.checkNotNull((Object)operation, (Object)"operation is null");
        return this.addStep(ctx, delta, operation, order, scriptPath, verb, options);
    }

    protected boolean addStep(DeploymentPlanningContext ctx, Delta delta, Operation operation, int order, String scriptPath, String verb, Set<String> options) {
        if (!Strings.isNullOrEmpty((String)scriptPath)) {
            Map<String, Object> vars = this.getVars(delta.getPrevious(), ctx.getDeployedApplication(), options);
            String description = this.getDescription(verb);
            PowerShellDeploymentStep step = new PowerShellDeploymentStep(order, (HostContainer)this.getContainer(), (Deployed<?, ?>)this, scriptPath, vars, description);
            step.setUploadArtifactData(options.contains(STEP_OPTION_UPLOAD_ARTIFACT_DATA));
            if (operation == null) {
                ctx.addStep((Step)step);
            } else {
                ctx.addStepWithCheckpoint((Step)step, delta, operation);
            }
            return true;
        }
        return false;
    }

    protected Map<String, Object> getVars(Deployed<?, ?> previous, DeployedApplication deployedApplication, Set<String> options) {
        HashMap vars = Maps.newHashMap();
        vars.put("deployed", this);
        if (options.contains(STEP_OPTION_EXPOSE_PREVIOUS_DEPLOYED)) {
            Preconditions.checkNotNull(previous, (Object)"previousDeployed is null");
            vars.put("previousDeployed", previous);
        }
        if (options.contains(STEP_OPTION_EXPOSE_DEPLOYED_APPLICATION)) {
            Preconditions.checkNotNull((Object)deployedApplication, (Object)"deployedApplication is null");
            vars.put("deployedApplication", deployedApplication);
        }
        return vars;
    }

    protected String getDescription(String verb) {
        return String.format("%s %s on %s", verb, this.getName(), ((HostContainer)this.getContainer()).getName());
    }

    public List<Step> controlTaskDispatch(String name, Map<String, String> args) {
        return ControlTaskDelegate.dispatch(name, args, (ConfigurationItem)this, (HostContainer)this.getContainer());
    }

    public List<String> getLibraryScripts() {
        return this.libraryScripts;
    }

    public int getDiscoverOrder() {
        return this.discoverOrder;
    }

    public void setDiscoverOrder(int discoverOrder) {
        this.discoverOrder = discoverOrder;
    }

    public String getDiscoverScript() {
        return this.discoverScript;
    }

    public void setDiscoverScript(String discoverScript) {
        this.discoverScript = discoverScript;
    }
}

