package com.xebialabs.deployit.plugin.powershell;

import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereFile;

import static com.xebialabs.deployit.plugin.powershell.PowerShellStep.getDefaultScriptCommandLine;

@SuppressWarnings("serial")
@Metadata(virtual = true)
public class BasePowerShellContainer extends BaseContainer implements PowerShellContainer {

    @Property(asContainment = true, description = "Host upon which the container resides")
    private Host host;

    @Property(required = false, hidden = true, defaultValue = "powershell", description = "")
    private String powerShellPath;

    @Property(required = false, hidden = true, defaultValue = "", description = "Runtime path for this container")
    private String runtimePath;

    @Override
    public Host getHost() {
        return host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    @Override
    public CmdLine getScriptCommandLine(OverthereFile script) {
        return getDefaultScriptCommandLine(powerShellPath, script);
    }

    @Override
    public String getRuntimePath() {
        if(runtimePath != null && runtimePath.length() > 0) {
            return runtimePath;
        } else {
            return null;
        }
    }

    public void setRuntimePath(String runtimePath) {
        this.runtimePath = runtimePath;
    }

    public List<Step> controlTaskDispatch(String name, Map<String,String> args) {
        return ControlTaskDelegate.dispatch(name, args, this, this);
    }

}
