/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.overthere.AutoFlushingExecutionContextOverthereProcessOutputHandler;
import com.xebialabs.deployit.plugin.powershell.PowerShellContainer;
import com.xebialabs.deployit.plugin.powershell.PowerShellVarsConverter;
import com.xebialabs.deployit.plugin.remoting.scripts.ScriptUtils;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Closeable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

abstract class PowerShellStep<C extends ExecutionContext>
implements Step<C> {
    private static final String STANDARD_RUNTIME_PATH = "powershell/runtime";
    private PowerShellContainer container;
    private String scriptPath;
    private Map<String, Object> powerShellVars;
    private String description;
    private boolean uploadArtifactData = true;
    private static Logger logger = LoggerFactory.getLogger(PowerShellStep.class);
    private static final Logger scriptsLogger = LoggerFactory.getLogger((String)"com.xebialabs.deployit.plugin.powershell.scripts");

    public PowerShellStep(PowerShellContainer powerShellContainer, String string, Map<String, Object> map, String string2) {
        this.container = (PowerShellContainer)Preconditions.checkNotNull((Object)powerShellContainer, (Object)"container is null");
        this.scriptPath = (String)Preconditions.checkNotNull((Object)string, (Object)"scriptPath is null");
        this.powerShellVars = (Map)Preconditions.checkNotNull(map, (Object)"powerShellVars is null");
        this.description = (String)Preconditions.checkNotNull((Object)string2, (Object)"description is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Step.Result doExecute(ExecutionContext executionContext) throws Exception {
        MDC.put((String)"scriptPath", (String)this.scriptPath);
        try {
            OverthereConnection overthereConnection;
            block8: {
                Step.Result result;
                overthereConnection = this.container.getHost().getConnection();
                try {
                    String string = this.aggregateScript(overthereConnection);
                    ScriptUtils.dumpScript((String)OverthereUtils.getName((String)this.scriptPath), (String)string, (Logger)scriptsLogger);
                    OverthereFile overthereFile = ScriptUtils.uploadScript((OverthereConnection)overthereConnection, (String)this.scriptPath, (String)string);
                    int n = this.executePowerShellScript(executionContext, overthereConnection, overthereFile);
                    logger.debug("Exit code: {}", (Object)n);
                    if (n != 0) break block8;
                    result = Step.Result.Success;
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly((Closeable)overthereConnection);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)overthereConnection);
                return result;
            }
            Step.Result result = Step.Result.Fail;
            Closeables.closeQuietly((Closeable)overthereConnection);
            return result;
        }
        finally {
            MDC.remove((String)"scriptPath");
        }
    }

    protected String aggregateScript(OverthereConnection overthereConnection) {
        String string = PowerShellVarsConverter.javaToPowerShell(overthereConnection, this.powerShellVars, this.uploadArtifactData);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ScriptUtils.loadScriptDir((String)STANDARD_RUNTIME_PATH));
        stringBuilder.append(ScriptUtils.loadScriptDir((String)this.container.getRuntimePath()));
        stringBuilder.append("# PowerShellVars\n");
        stringBuilder.append(string);
        stringBuilder.append(ScriptUtils.loadScript((String)this.scriptPath));
        return stringBuilder.toString().replaceAll("\n", "\r\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executePowerShellScript(ExecutionContext executionContext, OverthereConnection overthereConnection, OverthereFile overthereFile) {
        logger.info("Executing PowerShell script {} on {}", (Object)overthereFile, (Object)overthereConnection);
        AutoFlushingExecutionContextOverthereProcessOutputHandler autoFlushingExecutionContextOverthereProcessOutputHandler = new AutoFlushingExecutionContextOverthereProcessOutputHandler(executionContext);
        try {
            int n = overthereConnection.execute((OverthereProcessOutputHandler)autoFlushingExecutionContextOverthereProcessOutputHandler, this.container.getScriptCommandLine(overthereFile));
            return n;
        }
        finally {
            autoFlushingExecutionContextOverthereProcessOutputHandler.close();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setUploadArtifactData(boolean bl) {
        this.uploadArtifactData = bl;
    }
}

