#
from com.xebialabs.deployit.task import ArchivedTaskSearchParameters, TaskType
from java.util import EnumSet
from java.util.stream import Collectors
from java.util.function import Function

from policy.modules.util import minus_days_from_now

class jf(Function):
    def __init__(self, fn):
        self.apply = fn

class DefaultTaskCollector:
    def __init__(self, context, task_retention, task_types):
        self.task_archive = context.taskArchive
        self.task_types = task_types
        self.task_retention = task_retention

    def get_tasks_to_purge(self):
        end_date = minus_days_from_now(self.task_retention)
        params = ArchivedTaskSearchParameters().createdOnOrBefore(end_date)
        if self.task_types:
            type_set = EnumSet.noneOf(TaskType.getClass)
            for task_type in self.task_types:
                type_set.add(task_type)
                params = params.thatAreOfType(type_set)
        return self.task_archive.searchForTasks(params, False).map(jf(lambda t: t.fully())).collect(Collectors.toList())
