#
from java.util import EnumSet

from org.joda.time import LocalDate
from com.xebialabs.deployit.task import ArchivedTaskSearchParameters, TaskType


class DefaultTaskCollector:
    def __init__(self, context, task_retention, task_types):
        self.task_block_service = context.taskBlockService
        self.task_types = task_types
        self.task_retention = task_retention

    def get_tasks_to_purge(self):
        end_date = LocalDate.now().minusDays(self.task_retention + 1).toDateTimeAtStartOfDay()
        params = ArchivedTaskSearchParameters().createdOnOrBefore(end_date)
        if self.task_types:
            type_set = EnumSet.noneOf(TaskType.getClass)
            for task_type in self.task_types:
                type_set.add(task_type)
                params = params.thatAreOfType(type_set)
        return self.task_block_service.search(params, True)
