import traceback
from org.joda.time import LocalDate


class Struct(dict):
    def __init__(self, *args, **kw):
        super(Struct, self).__init__(*args, **kw)

    def __getattr__(self, name):
        return self[name]

    def __setattr__(self, name, value):
        self[name] = value

    def __delattr__(self, name):
        del self[name]


class LoggerWrapper:
    def __init__(self, context):
        self.context = context

    def info(self, message):
        self.context.logOutput(message)

    def error(self, message):
        self.context.logError(message)
        self.context.logError(traceback.format_exc())


def minus_days_from_now(days):
    return LocalDate.now().minusDays(days).toDateTimeAtCurrentTime()

