/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.osb.freemarker;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateEvaluator {
    protected static final Logger logger = LoggerFactory.getLogger(TemplateEvaluator.class);

    public static void evaluateTemplate(OverthereFile overthereFile, String string, Map<String, Object> map) {
        Configuration configuration = ConfigurationHolder.getConfiguration();
        OutputStream outputStream = overthereFile.getOutputStream();
        try {
            Template template = configuration.getTemplate(string);
            template.process(map, (Writer)new OutputStreamWriter(outputStream));
        }
        catch (IOException iOException) {
            throw new RuntimeIOException((Throwable)iOException);
        }
        catch (TemplateException templateException) {
            throw new RuntimeException(templateException);
        }
        finally {
            Closeables.closeQuietly((Closeable)outputStream);
        }
    }
}

