#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import os
from java.util import Date
from com.bea.wli.sb.util import Refs
from com.bea.wli.config.customization import Customization
from com.bea.wli.sb.management.importexport import ALSBImportOperation
from java.util import Collections
from com.bea.wli.config import Ref

''' getFiles()
Search file in a given folder.
'''
def getFiles(directory,extension):
	print "Search in %s for %s" % (directory, extension)
	candidates = [file for file in os.listdir(directory) if file.lower().endswith(extension)]
	return ["%s/%s" % (directory,c)for c in candidates]

''' printOpMap()
Print the list of operations.
'''
def printOpMap(map):
    print "Import plan's operations"
    set = map.entrySet()
    for entry in set:
        op = entry.getValue()
        ref = entry.getKey()
        print "  %s->%s" % (op.getOperation(), ref)



''' printDiagMap()
Print the diagnostics.
'''
def printDiagMap(map):
    print "Diagnostic map"
    set = map.entrySet()
    for entry in set:
        diag = entry.getValue().toString()
        print "  %s" % (diag)


''' printTargets
Print customization targets.
'''
def printTargets(customization):
    for target in customization.getTargets():
        print "  %s." % (target)


''' readBinaryFile()
Read a binary file.
Input Parameters
    pConfigFile     : string containing the name of the binary file
Output Parameters
    bytes           : array of bytes containing the content of the binary file
'''
def readBinaryFile(filename):
    file = open(filename, 'rb')
    bytes = file.read()
    file.close()
    return bytes

#=======================================================================================
# Utility function to create an arbitrary session name
#=======================================================================================
def createSessionName():
    #sessionName = String("DeployIt-Import-"+Long(System.currentTimeMillis()).toString())
    return "Deployit-Session-%s" % (System.currentTimeMillis())

#=======================================================================================
# Utility function to load a session MBeans
#=======================================================================================
def getSessionManagementMBean(sessionName):
    SessionMBean = findService("SessionManagement","com.bea.wli.sb.management.configuration.SessionManagementMBean")
    SessionMBean.createSession(sessionName)
    return SessionMBean

# delete a set of project.
def deleteProjects(ALSBConfigurationMBean, projectNames):
	for project in projectNames:
		print 'Delete Project %s' % project
		ref = Ref.makeProjectRef(project);
		collection = Collections.singleton(ref)
		ALSBConfigurationMBean.delete(collection)

