/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.netscaler;

import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.netscaler.NetScalerItem;

public class ServiceGroup
extends NetScalerItem {
    private String serviceGroup;
    private String serviceName;
    private int servicePort;

    ServiceGroup(Deployed d) {
        this.serviceGroup = (String)d.getProperty("netscalerServiceGroup");
        this.serviceName = (String)d.getProperty("netscalerServiceGroupName");
        this.servicePort = (Integer)d.getProperty("netscalerServiceGroupPort");
    }

    public ServiceGroup(String serviceGroup, String serviceName, int servicePort) {
        this.serviceGroup = serviceGroup;
        this.serviceName = serviceName;
        this.servicePort = servicePort;
    }

    public String toString() {
        return String.format("%s(%s %s)", this.serviceGroup, this.serviceName, this.servicePort);
    }

    @Override
    public int getDelay() {
        return 0;
    }

    @Override
    public String getDelayString() {
        return "-delay " + this.getDelay();
    }

    @Override
    public String getAddress() {
        return String.format("%s %s %s", this.serviceGroup, this.serviceName, this.servicePort);
    }

    @Override
    public String getNetScalerType() {
        return "serviceGroup";
    }
}

