/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.lb.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.lb.ci.LoadBalancer;
import com.xebialabs.deployit.plugin.lb.util.DeploymentGroups;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancedContainers {
    public static final String WEBSERVER_FRONTED_CONTAINERS_PROPERTY = "applicationServers";
    public static final String CONTAINER_REMOVE_FROM_POOL_PROPERTY = "disableInLoadBalancer";
    private static final Logger logger = LoggerFactory.getLogger(LoadBalancedContainers.class);

    public static ListMultimap<Container, LoadBalancer> getContainerToLoadBalancersMap(Set<LoadBalancer> loadBalancers, Set<Container> containers) {
        ArrayListMultimap loadBalancedContainers = ArrayListMultimap.create();
        for (LoadBalancer loadBalancer : loadBalancers) {
            for (Container appserver : loadBalancer.getManagedServers()) {
                if (!Boolean.TRUE.equals(appserver.getProperty(CONTAINER_REMOVE_FROM_POOL_PROPERTY)) || !containers.contains(appserver)) continue;
                loadBalancedContainers.put((Object)appserver, (Object)loadBalancer);
            }
        }
        return loadBalancedContainers;
    }

    public static ListMultimap<Container, LoadBalancer> getAffectedWebServers(Set<LoadBalancer> loadBalancers, Set<Container> containers) {
        ArrayListMultimap loadBalancedContainers = ArrayListMultimap.create();
        for (LoadBalancer loadBalancer : loadBalancers) {
            for (Container webserver : loadBalancer.getManagedServers()) {
                Set frontedServers;
                if (!Boolean.TRUE.equals(webserver.getProperty(CONTAINER_REMOVE_FROM_POOL_PROPERTY)) || !webserver.hasProperty(WEBSERVER_FRONTED_CONTAINERS_PROPERTY) || Sets.intersection((Set)(frontedServers = (Set)webserver.getProperty(WEBSERVER_FRONTED_CONTAINERS_PROPERTY)), containers).isEmpty()) continue;
                loadBalancedContainers.put((Object)webserver, (Object)loadBalancer);
            }
        }
        return loadBalancedContainers;
    }

    public static Map<Container, LoadBalancingBounds> getLoadBalancingBounds(Set<Container> containers) {
        ImmutableMap.Builder loadBalancingBounds = ImmutableMap.builder();
        for (Container container : containers) {
            loadBalancingBounds.put((Object)container, (Object)new LoadBalancingBounds(container));
        }
        return loadBalancingBounds.build();
    }

    public static class LoadBalancingBounds {
        public final int startGroup;
        public final int endGroup;

        private LoadBalancingBounds(Container container) {
            if (container.hasProperty(LoadBalancedContainers.WEBSERVER_FRONTED_CONTAINERS_PROPERTY)) {
                ArrayList deploymentGroups = Lists.newArrayList((Object[])new Integer[]{DeploymentGroups.getDeploymentGroup(container)});
                Set frontedServers = (Set)container.getProperty(LoadBalancedContainers.WEBSERVER_FRONTED_CONTAINERS_PROPERTY);
                for (Container frontedServer : frontedServers) {
                    deploymentGroups.add(DeploymentGroups.getDeploymentGroup(frontedServer));
                }
                Collections.sort(deploymentGroups);
                this.startGroup = (Integer)deploymentGroups.get(0);
                this.endGroup = (Integer)deploymentGroups.get(deploymentGroups.size() - 1);
            } else {
                this.endGroup = this.startGroup = DeploymentGroups.getDeploymentGroup(container);
            }
            logger.debug("Determined load balancing bounds for '{}': start '{}', end '{}'", new Object[]{container, this.startGroup, this.endGroup});
        }
    }
}

