package com.xebialabs.deployit.plugin.netscaler;

import com.xebialabs.deployit.plugin.api.udm.Deployed;

import static java.lang.String.format;

public class ServiceGroup extends NetScalerItem {
    private String serviceGroup;
    private String serviceName;
    private int servicePort;

    ServiceGroup(Deployed d) {
        serviceGroup = d.<String>getProperty(NetScaler.SERVICE_GROUP);
        serviceName = d.<String>getProperty(NetScaler.SERVICE_GROUP_SERVICE_NAME);
        servicePort = d.<Integer>getProperty(NetScaler.SERVICE_GROUP_SERVICE_PORT);
    }

    public ServiceGroup(String serviceGroup, String serviceName, int servicePort) {
        this.serviceGroup = serviceGroup;
        this.serviceName = serviceName;
        this.servicePort = servicePort;
    }

    @Override
    public String toString() {
        return format("%s(%s %s)", serviceGroup, serviceName, servicePort);
    }

    @Override
    public int getDelay() {
        return 0;
    }

    @Override
    public String getDelayString() {
        return "-delay " + getDelay();
    }

    @Override
    public String getAddress() {
        return format("%s %s %s", serviceGroup, serviceName, servicePort);
    }

    @Override
    public String getNetScalerType() {
        return "serviceGroup";
    }
}
